/*****************************************************************************/
/*!
 *\file simulate_theorem_producer.h
 *\brief Implementation of the symbolic simulator proof rules
 *
 * Author: Sergey Berezin
 *
 * Created: Tue Oct  7 10:49:14 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/

#ifndef _cvcl__theory_simulate__simulate_theorem_producer_h_
#define _cvcl__theory_simulate__simulate_theorem_producer_h_

#include "theorem_producer.h"
#include "simulate_proof_rules.h"

namespace CVCL {

class SimulateTheoremProducer:
    public SimulateProofRules, public TheoremProducer {
public:
  //! Constructor
  SimulateTheoremProducer(TheoremManager* tm): TheoremProducer(tm) { }
  virtual ~SimulateTheoremProducer() { }

  virtual Theorem expandSimulate(const Expr& e);

  /*
private:
  Expr substFreeTerm(const Expr& e, const Expr& oldE, const Expr& newE);
  Expr recursiveSubst(const Expr& e, const Expr& oldE, const Expr& newE,
		      ExprMap<Expr>& visited);
  */

}; // end of class SimulateTheoremProducer

} // end of namespace CVCL 

#endif
