/*****************************************************************************/
/*!
 *\file simulate_proof_rules.h
 *\brief Abstract interface to the symbolic simulator proof rules 
 *
 * Author: Sergey Berezin
 *
 * Created: Tue Oct  7 10:44:42 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/

#ifndef _cvcl__theory_simulate__simulate_proof_rules_h_
#define _cvcl__theory_simulate__simulate_proof_rules_h_

namespace CVCL {

  class Expr;
  class Theorem;

class SimulateProofRules {
public:
  //! Destructor
  virtual ~SimulateProofRules() { }

  //! SIMULATE(f, s_0, i_1, ..., i_k, N) <=> f(...f(f(s_0, i_1), i_2), ... i_k)
  virtual Theorem expandSimulate(const Expr& e) = 0;

}; // end of class SimulateProofRules

} // end of namespace CVCL

#endif
