/*****************************************************************************/
/*!
 * \file quant_theorem_producer.h
 * 
 * Author: Daniel Wichs
 * 
 * Created: Jul 07 22:22:38 GMT 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/
#ifndef _CVC_lite__quant_theorem_producer_h_
#define _CVC_lite__quant_theorem_producer_h_

#include "quant_proof_rules.h"
#include "theorem_producer.h"
#include "theory_quant.h"

namespace CVCL {
  
  class QuantTheoremProducer: public QuantProofRules, public TheoremProducer {
    TheoryQuant* d_theoryQuant;
  private:
    //! find all bound variables in e and maps them to true in boundVars
    void recFindBoundVars(const Expr& e, 
			  ExprMap<bool> & boundVars, ExprMap<bool> &visited);
  public:
    //! Constructor
    QuantTheoremProducer(TheoremManager* tm, TheoryQuant* theoryQuant):
      TheoremProducer(tm), d_theoryQuant(theoryQuant) {}

    //! ==> NOT EXISTS (vars): e  IFF FORALL (vars) NOT e
    virtual Theorem rewriteNotExists(const Expr& e);
    //! ==> NOT FORALL (vars): e  IFF EXISTS (vars) NOT e 
    virtual Theorem rewriteNotForall(const Expr& e);
    //! Instantiate a  universally quantified formula
    /*! From T|-FORALL(var): e generate T|-e' where e' is obtained
     * from e by instantiating bound variables with terms in
     * vector<Expr>& terms.  The vector of terms should be the same
     * size as the vector of bound variables in e. Also elements in
     * each position i need to have matching types.
     * \param t1 is the quantifier (a Theorem)
     * \param terms are the terms to instantiate.
     */
    virtual Theorem universalInst(const Theorem& t1,
				  const std::vector<Expr>& terms);
    
    /*! @brief From T|- QUANTIFIER (vars): e we get T|-QUANTIFIER(vars') e
     * where vars' is obtained from vars by removing all bound variables
     *  not used in e. If vars' is empty the produced theorem is just T|-e
     */
    virtual Theorem boundVarElim(const Theorem& t1);


  }; 

} 

#endif
