/*****************************************************************************/
/*!
 * \file typecheck_exception.h
 * \brief An exception to be thrown at typecheck error.
 * 
 * Author: Sergey Berezin
 * 
 * Created: Fri Feb 14 18:44:15 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/

#ifndef _CVC_lite__typecheck_exception_h_
#define _CVC_lite__typecheck_exception_h_

#include <string>
#include <iostream>
#include "exception.h"

namespace CVCL {

  class TypecheckException: public Exception {
  public:
    // Constructors
    TypecheckException() { }
    TypecheckException(const std::string& msg): Exception(msg) { }
    TypecheckException(char* msg): Exception(msg) { }
    // Destructor
    virtual ~TypecheckException() { }
    virtual std::string toString() const {
      return "Type Checking error: " + d_msg;
    }
  }; // end of class TypecheckException
} // end of namespace CVCL 

#endif
