/*****************************************************************************/
/*!
 * \file notifylist.h
 * 
 * Author: Clark Barrett
 * 
 * Created: Mon Jan 20 13:52:19 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/

#ifndef _cvcl__include__notifylist_h_ 
#define _cvcl__include__notifylist_h_  

#include "expr.h"
#include "cdlist.h"

namespace CVCL {

  class Theory;

class NotifyList {
  CDList<Theory*> d_tlist;
  CDList<Expr> d_elist;

public:
  NotifyList(Context* c) : d_tlist(c), d_elist(c) {
    IF_DEBUG(d_elist.setName("CDList[NotifyList]"));
  }
  unsigned size() const { return d_tlist.size(); }
  void add(Theory* t, const Expr& e) { d_tlist.push_back(t); d_elist.push_back(e); }
  Theory* getTheory(int i) const { return d_tlist[i]; }
  Expr getExpr(int i) const { return d_elist[i]; }
};

}

#endif
