/*****************************************************************************/
/*!
 * \file eval_exception.h
 * 
 * Author: Sergey Berezin
 * 
 * Created: Tue Feb 25 14:58:57 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 * An exception thrown on an error while evaluating a command.  Use it
 * only when the error does not fall under any of the standard cases
 * like typecheck or parse errors.
 */
/*****************************************************************************/

#ifndef _CVC_lite__eval_exception_h_
#define _CVC_lite__eval_exception_h_

#include "exception.h"

namespace CVCL {
class EvalException: public Exception {
public:
  // Constructors
  EvalException() { }
  EvalException(const std::string& msg): Exception(msg) { }
  EvalException(char* msg): Exception(msg) { }
  // Destructor
  virtual ~EvalException() { }
  // Printing the message
  virtual std::string toString() const {
    return "Error while evaluating a command:\n  " + d_msg;
  }
};

}

#endif
