/*****************************************************************************/
/*!
 * \file command_line_exception.h
 * 
 * Author: Sergey Berezin
 * 
 * Created: Fri May 30 14:59:51 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 * An exception thrown on an error while processing a command line
 * argument.
 */
/*****************************************************************************/

#ifndef _CVC_lite__command_line_exception_h_
#define _CVC_lite__command_line_exception_h_

#include "exception.h"

namespace CVCL {
class CLException: public Exception {
public:
  // Constructors
  CLException() { }
  CLException(const std::string& msg): Exception(msg) { }
  CLException(char* msg): Exception(msg) { }
  // Destructor
  virtual ~CLException() { }
  // Printing the message
  virtual std::string toString() const {
    return "Error while processing a command line option:\n  " + d_msg;
  }
};

}

#endif
