/*****************************************************************************/
/*!
 *\file datatype_theorem_producer.h
 *\brief TRUSTED implementation of recursive datatype proof rules
 *
 * Author: Clark Barrett
 *
 * Created: Mon Jan 10 15:42:22 2005
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 * CLASS: DatatypeTheoremProducer
 * 
 */
/*****************************************************************************/
#ifndef _cvcl__theory_datatype__datatype_theorem_producer_h_
#define _cvcl__theory_datatype__datatype_theorem_producer_h_

#include "datatype_proof_rules.h"
#include "theorem_producer.h"
#include "theory_datatype.h"
#include "theory_core.h"

namespace CVCL {
  
class DatatypeTheoremProducer: public DatatypeProofRules, public TheoremProducer {
  TheoryDatatype* d_theoryDatatype;
private:
public:
  //! Constructor
  DatatypeTheoremProducer(TheoryDatatype* theoryDatatype) :
    TheoremProducer(theoryDatatype->theoryCore()->getTM()),
    d_theoryDatatype(theoryDatatype) { }

  Theorem dummyTheorem(const CDList<Theorem>& facts, const Expr& e);
  Theorem rewriteSelCons(const CDList<Theorem>& facts, const Expr& e);
  Theorem rewriteTestCons(const Expr& e);
  Theorem decompose(const Theorem& e);
  Theorem noCycle(const Expr& e);

  }; // end of class DatatypeTheoremProducer
} // end of namespace CVCL

#endif

