/*****************************************************************************/
/*!
 *\file datatype_proof_rules.h
 *\brief Abstract interface for recursive datatype proof rules
 *
 * Author: Clark Barrett
 *
 * Created: Mon Jan 10 15:40:24 2005
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 * CLASS: DatatypeProofRules
 * 
 */
/*****************************************************************************/

#ifndef _cvcl__theory_datatype__datatype_proof_rules_h_
#define _cvcl__theory_datatype__datatype_proof_rules_h_

namespace CVCL {

  class Expr;
  class Theorem;
  template<class T> class CDList;

  class DatatypeProofRules {
  public:
    // Destructor
    virtual ~DatatypeProofRules() { }

    ////////////////////////////////////////////////////////////////////
    // Proof rules
    ////////////////////////////////////////////////////////////////////

    virtual Theorem dummyTheorem(const CDList<Theorem>& facts,
                                 const Expr& e) = 0;
    virtual Theorem rewriteSelCons(const CDList<Theorem>& facts, const Expr& e) = 0;
    virtual Theorem rewriteTestCons(const Expr& e) = 0;
    virtual Theorem decompose(const Theorem& e) = 0;
    virtual Theorem noCycle(const Expr& e) = 0;

  }; // end of class DatatypeProofRules

} // end of namespace CVCL

#endif
