/*****************************************************************************/
/*!
 * \file core_theorem_producer.h
 * 
 * Author: Sergey Berezin
 * 
 * Created: Feb 05 03:40:36 GMT 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/
// CLASS: CoreTheoremProducer
//
// AUTHOR: Sergey Berezin, 12/09/2002
//
// Description: Implementation of the proof rules for ground
// equational logic (reflexivity, symmetry, transitivity, and
// substitutivity).
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _CVC_lite__core_theorem_producer_h_
#define _CVC_lite__core_theorem_producer_h_

#include "core_proof_rules.h"
#include "theorem_producer.h"

namespace CVCL {

  class TheoryCore;

  class CoreTheoremProducer: public CoreProofRules, public TheoremProducer {
  private:
    //! pointer to theory core
    TheoryCore* d_core;

  public:
    CoreTheoremProducer(TheoremManager* tm, TheoryCore* core)
      : TheoremProducer(tm), d_core(core) { }
    virtual ~CoreTheoremProducer() { }

    Theorem3 queryTCC(const Theorem& phi, const Theorem& D_phi);
    Theorem3 implIntro3(const Theorem3& phi,
			const std::vector<Expr>& assump,
			const std::vector<Theorem>& tccs);
    Theorem typePred(const Expr& e);
    Theorem rewriteLetDecl(const Expr& e);
    Theorem rewriteNotAnd(const Expr& e);
    Theorem rewriteNotOr(const Expr& e);
    Theorem rewriteNotIff(const Expr& e);
    Theorem rewriteNotIte(const Expr& e);
    Theorem rewriteIteTrue(const Expr& e);
    Theorem rewriteIteFalse(const Expr& e);
    Theorem rewriteIteSame(const Expr& e);
    Theorem rewriteIteThen(const Expr& e, const Theorem& thenThm);
    Theorem rewriteIteElse(const Expr& e, const Theorem& elseThm);
    Theorem rewriteIteBool(const Expr& c,
			   const Expr& e1, const Expr& e2);
    Theorem orDistributivityRule(const Expr& e);
    Theorem andDistributivityRule(const Expr& e);
    Theorem rewriteImplies(const Expr& e);
    Theorem NotToIte(const Expr& not_e);
    Theorem OrToIte(const Expr& e);
    Theorem AndToIte(const Expr& e);
    Theorem IffToIte(const Expr& e);
    Theorem ImpToIte(const Expr& e);
    Theorem rewriteIteToNot(const Expr& e);
    Theorem rewriteIteToOr(const Expr& e);
    Theorem rewriteIteToAnd(const Expr& e);
    Theorem rewriteIteToIff(const Expr& e);
    Theorem rewriteIteToImp(const Expr& e);
    Theorem rewriteIteCond(const Expr& e);
    Theorem ifLiftUnaryRule(const Expr& e);
    Theorem iffOrDistrib(const Expr& iff);
    Theorem iffAndDistrib(const Expr& iff);
    Theorem rewriteAndSubterms(const Expr& e, int idx);
    Theorem rewriteOrSubterms(const Expr& e, int idx);

  }; // end of class CoreTheoremProducer

} // end of namespace CVCL

#endif
