/*****************************************************************************/
/*!
 *\file cnf_theorem_producer.h
 *\brief Implementation of CNF_Rules API
 *
 * Author: Clark Barrett
 *
 * Created: Thu Jan  5 05:33:42 2006
 *
 * <hr>
 * Copyright (C) 2006 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/

#ifndef _cvcl__sat__cnf_theorem_producer_h_
#define _cvcl__sat__cnf_theorem_producer_h_

#include "theorem_producer.h"
#include "cnf_rules.h"

namespace CVCL {

  class CNF_TheoremProducer
    : public CNF_Rules,
      public TheoremProducer {

  public:
    CNF_TheoremProducer(TheoremManager* tm): TheoremProducer(tm) { }
    ~CNF_TheoremProducer() { }

    Theorem learnedClause(const Theorem& thm);
    Theorem ifLiftRule(const Expr& e, int itePos);

  }; // end of class CNF_TheoremProducer
} // end of namespace CVCL
#endif
