/*****************************************************************************/
/*!
 * \file vc_cmd.h
 * 
 * Author: Clark Barrett
 * 
 * Created: Fri Dec 13 22:35:15 2002
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/

#ifndef _cvcl__vc_cvc__vc_cmd_h_
#define _cvcl__vc_cvc__vc_cmd_h_

#include <string>
#include "compat_hash_map.h"
#include "exception.h"
#include "queryresult.h"

namespace CVCL {

  class ValidityChecker;
  class Parser;
  class Context;  
  class Expr;

  template<class Data>
  class ExprMap;

class VCCmd {
  ValidityChecker* d_vc;
  Parser* d_parser;
  // TODO: move state variables into validity checker.
  typedef std::hash_map<const char*, Context*> CtxtMap;
  std::string d_name_of_cur_ctxt;
  CtxtMap d_map;

  //! Take a parsed Expr and evaluate it
  bool evaluateCommand(const Expr& e) throw(Exception);
  // Fetch the next command and evaluate it.  Return true if
  // evaluation was successful, false otherwise.  In especially bad
  // cases an exception may be thrown.
  bool evaluateNext() throw(Exception);
  void findAxioms(const Expr& e, ExprMap<bool>& skolemAxioms,
		  ExprMap<bool>& visited);
  Expr skolemizeAx(const Expr& e);
  void reportResult(QueryResult qres, bool checkingValidity = true);

public:
  VCCmd(ValidityChecker* vc, Parser* parser);
  ~VCCmd();

  // Main loop function
  void processCommands();
};

}

#endif
