/*****************************************************************************/
/*!
 * \file smtlib_exception.h
 * \brief An exception to be thrown by the smtlib translator.
 * 
 * Author: Clark Barrett
 * 
 * Created: Thu Feb 24 18:22:18 2005
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/

#ifndef _CVC_lite__smtlib_exception_h_
#define _CVC_lite__smtlib_exception_h_

#include <string>
#include <iostream>
#include "exception.h"

namespace CVCL {

  class SmtlibException: public Exception {
  public:
    // Constructors
    SmtlibException() { }
    SmtlibException(const std::string& msg): Exception(msg) { }
    SmtlibException(char* msg): Exception(msg) { }
    // Destructor
    virtual ~SmtlibException() { }
    virtual std::string toString() const {
      return "SMTLIB translation error: " + d_msg;
    }
  }; // end of class SmtlibException
} // end of namespace CVCL 

#endif
