/*****************************************************************************/
/*!
 * \file search_simple.h
 * 
 * Author: Clark Barrett
 * 
 * Created: Sat Mar 29 21:53:46 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/

#ifndef _cvcl__include__search_simple_h_
#define _cvcl__include__search_simple_h_

#include "search_impl_base.h"
#include "statistics.h"

namespace CVCL {

class DecisionEngine;

/*!
 * \defgroup SE_Simple Simple Search Engine
 * \ingroup SE
 *
 * This module includes all the components of a very simplistic search
 * engine.  It is used mainly for debugging purposes.
 */

  //! Implementation of the simple search engine
  /*! \ingroup SE_Simple */
class SearchSimple: public SearchImplBase {
  /*! \addtogroup SE_Simple 
   * @{
   */

  //! Name
  std::string d_name;

  //! Decision Engine
  DecisionEngine* d_decisionEngine;

  //! Formula being checked
  CDO<Theorem> d_goal;
  //! Non-literals generated by DP's
  CDO<Theorem> d_nonLiterals;
  //! Theorem which records simplification of the last query
  CDO<Theorem> d_simplifiedThm;

  //! Recursive DPLL algorithm used by checkValid
  QueryResult checkValidRec(Theorem& thm);
  //! Private helper function for checkValid and restart
  QueryResult checkValidMain(const Expr& e2, unsigned& budget);

public:
  //! Constructor
  SearchSimple(TheoryCore* core);
  //! Destructor
  ~SearchSimple();
  
  // Implementation of virtual SearchEngine methods
  const std::string& getName() { return d_name; }
  QueryResult checkValidInternal(const Expr& e, unsigned& budget);
  QueryResult restartInternal(const Expr& e, unsigned& budget);
  void addLiteralFact(const Theorem& thm) {}
  void addNonLiteralFact(const Theorem& thm);

  /*! @} */ // end addtogroup SE_Simple
};

}

#endif
