/*****************************************************************************/
/*!
 * \file parser_exception.h
 * \brief An exception thrown by the parser.
 * 
 * Author: Sergey Berezin
 * 
 * Created: Thu Feb  6 13:23:39 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/

#ifndef _cvcl__parser_exception_h_
#define _cvcl__parser_exception_h_

#include "exception.h"
#include <string>
#include <iostream>

namespace CVCL {

  class ParserException: public Exception {
  public:
    // Constructors
    ParserException() { }
    ParserException(const std::string& msg): Exception(msg) { }
    ParserException(char* msg): Exception(msg) { }
    // Destructor
    virtual ~ParserException() { }
    virtual std::string toString() const {
      return "Parse Error: " + d_msg;
    }
  }; // end of class ParserException

} // end of namespace CVCL 

#endif
