/*****************************************************************************/
/*!
 * \file exception.h
 * 
 * Author: Sergey Berezin
 * 
 * Created: Thu Feb  6 13:09:44 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 * A generic exception.  Any thrown exception must inherit from this
 * class and whenever possible, set the error message.
 */
/*****************************************************************************/

#ifndef _CVC_lite__exception_h_
#define _CVC_lite__exception_h_

#include <string>
#include <iostream>

namespace CVCL {

  class Exception {
  protected:
    std::string d_msg;
  public:
    // Constructors
    Exception(): d_msg("Unknown exception") { }
    Exception(const std::string& msg): d_msg(msg) { }
    Exception(char* msg): d_msg(msg) { }
    // Destructor
    virtual ~Exception() { }
    // NON-VIRTUAL METHODs for setting and printing the error message
    void setMessage(const std::string& msg) { d_msg = msg; }
    // Printing: feel free to redefine toString().  When inherited,
    // it's recommended that this method print the type of exception
    // before the actual message.
    virtual std::string toString() const { return d_msg; }
    // No need to overload operator<< for the inherited classes
    friend std::ostream& operator<<(std::ostream& os, const Exception& e);

  }; // end of class Exception

  inline std::ostream& operator<<(std::ostream& os, const Exception& e) {
    return os << e.toString();
  }

} // end of namespace CVCL 

#endif
