/*****************************************************************************/
/*!
 * \file compat_hash_map.h
 * 
 * Author: Sergey Berezin
 * 
 * Created: Jan 31 02:23:26 GMT 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 * Compatibility header file for STL extension "hash_map".  Any other
 * source file that needs to use hash_map should include this instead.
 * 
 * If hash_map is not defined in namespace std, we bring it in there.
 * It turns out that different versions of gcc use different
 * namespaces for STL extensions (std, __gnu_cxx, and God knows
 * what'll be next).
 * 
 * This header assumes that only one of HAVE_*_HASH_MAP symbols is
 * defined.
 * 
 */
/*****************************************************************************/
#ifndef _cvcl__include__compat_hash_map_h_
#define _cvcl__include__compat_hash_map_h_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_STD__HASH_MAP
#include <hash_map>
#endif

#ifdef HAVE___GNU_CXX__HASH_MAP
#include <hash_map>
namespace std {
  using __gnu_cxx::hash_map;
};
#endif

#ifdef HAVE_STD__EXT_HASH_MAP
#include <ext/hash_map>
#endif

#ifdef HAVE___GNU_CXX__EXT_HASH_MAP
#include <ext/hash_map>
namespace std {
  using __gnu_cxx::hash_map;
};
#endif

#endif
