/*****************************************************************************/
/*!
 *\file cdflags.cpp
 *\brief Implementation for CDFlags class
 *
 * Author: Clark Barrett
 *
 * Created: Thu Jan 26 16:53:28 2006
 *
 * <hr>
 * Copyright (C) 2006 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/


#include "cdflags.h"


using namespace CVCL;
using namespace std;


void CDFlags::update(unsigned mask, int scope, bool setMask)
{
  DebugAssert(mask && (mask & (mask-1)) == 0, "Expected single bit mask");
  if (scope < 0 || d_scope->level() <= scope) {
    makeCurrent(scope);
    if (setMask) d_flags = d_flags | mask;
    else d_flags = d_flags & ~mask;
  }
  else {
    // Kind of ugly: have to "change the past", but that's the price we pay for
    // keeping all the flags in one word for efficiency.
    IF_DEBUG(bool on = (d_flags & mask);)

    // Update current object
    if (setMask) d_flags = d_flags | mask;
    else d_flags = d_flags & ~mask;

    ContextObjChain** lastPtr = &d_restore;
    CDFlags* pastFlags;
    Scope* lastScope = d_scope;
    bool done = false;

    // Update past objects
    while (true) {
      pastFlags = (CDFlags*)((*lastPtr)->d_data);
      if (pastFlags->d_scope->level() >= scope) {
        DebugAssert(on && (pastFlags->d_flags & mask) ||
                    !on && !(pastFlags->d_flags & mask),
                    "Expected no change in flag since scope");
        if (setMask) {
          pastFlags->d_flags = pastFlags->d_flags | mask;
        }
        else {
          pastFlags->d_flags = pastFlags->d_flags & ~mask;
        }
        if (pastFlags->d_scope->level() == scope) {
          done = true; break;
        }
        lastScope = pastFlags->d_scope;
      } else break;
      lastPtr = &((*lastPtr)->d_restore);
      DebugAssert(*lastPtr != NULL, "Should always be object at scope 0");
    }
    if (done) return;

    // No past object exists at the target scope: create one
    DebugAssert(lastScope != NULL &&
                lastScope->level() > scope,
                "Expected lastScope to be above target scope");
    while (lastScope->level() > scope) lastScope = lastScope->prevScope();
    ContextObj* data = (*lastPtr)->d_data->makeCopy();
    data->d_scope = lastScope;
    data->d_restore = NULL;
    ContextObjChain* obj = new ContextObjChain(data, this, *lastPtr);
    *lastPtr = obj;
    lastScope->addToChain(obj);
  }
}
