/*
 * Decompiled with CFR 0.152.
 */
package cvc3;

import cvc3.CLException;
import cvc3.Cvc3Exception;
import cvc3.Flag;
import cvc3.Flags;
import cvc3.FlagsMut;
import cvc3.TimeoutHandler;
import cvc3.ValidityChecker;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

class Cvc3 {
    static boolean useObjManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    Cvc3() {
    }

    static void timeoutHandler(Object o) {
        System.out.println("self-timeout.");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Cvc3Exception {
        ValidityChecker vc = null;
        FlagsMut flags = null;
        try {
            flags = ValidityChecker.createFlags(null);
            String fileName = "";
            try {
                fileName = Cvc3.parse_args(args, flags);
            }
            catch (CLException e) {
                System.err.print("*** " + e);
                System.err.println("\n\nRun with -help option for usage information.");
                System.exit(1);
            }
            int timeout = flags.getFlag("timeout").getInt();
            if (timeout > 0) {
                new Timer().schedule((TimerTask)new TimeoutHandler(), timeout * 1000);
            }
            vc = ValidityChecker.create(flags);
            flags.delete();
            if (!vc.getFlags().getFlag("help").getBool()) {
                String programName = "cvc3";
                Cvc3.printUsage(vc.getFlags(), programName);
                System.exit(0);
            }
            if (!vc.getFlags().getFlag("version").getBool()) {
                System.out.println("This is CVC3 version UNKNOWN");
                System.out.println("Copyright (C) 2003-2006 by the Board of Trustees of Leland Stanford Junior");
                System.out.println("University, New York University, and the University of Iowa.");
                System.out.println();
                System.out.print("THIS SOFTWARE PROVIDED AS-IS, WITHOUT ANY WARRANTIES. ");
                System.out.println("USE IT AT YOUR OWN RISK.");
                System.out.println();
                System.exit(0);
            }
            vc.getExprManager().getOutputLanguage();
            vc.loadFile(fileName, vc.getExprManager().getInputLanguage());
            if (vc.getFlags().getFlag("stats").getBool()) {
                vc.printStatistics();
            }
        }
        catch (Cvc3Exception e) {
            System.err.println("*** Fatal exception: " + e);
            System.exit(1);
        }
        finally {
            if (flags != null) {
                flags.delete();
            }
            if (vc != null) {
                vc.delete();
            }
        }
        System.exit(0);
    }

    public static String parse_args(String[] args, FlagsMut flags) throws Cvc3Exception {
        String fileName = "";
        boolean seenFileName = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-") || arg.startsWith("+")) {
                List names = flags.getFlags(arg.substring(1));
                if (names.size() == 0) {
                    throw new CLException(arg + " does not match any known option");
                }
                if (names.size() > 1) {
                    StringBuffer s = new StringBuffer();
                    s.append(arg + " is ambiguous.  Possible matches are:\n");
                    Iterator name = names.iterator();
                    while (name.hasNext()) {
                        s.append("  " + name.next() + "\n");
                    }
                    throw new CLException(s.toString());
                }
                String name = (String)names.iterator().next();
                boolean val = arg.startsWith("+");
                Flag flag = flags.getFlag(name);
                if (flag.isBool()) {
                    flags.setFlag(name, val);
                    continue;
                }
                if (flag.isInt()) {
                    if (++i >= args.length) {
                        throw new CLException(arg + " (-" + name + ") expects an integer argument.");
                    }
                    int parameter = Integer.parseInt(args[i]);
                    flags.setFlag(name, parameter);
                    continue;
                }
                if (flag.isString()) {
                    if (++i >= args.length) {
                        throw new CLException(arg + " (-" + name + ") expects a string argument.");
                    }
                    flags.setFlag(name, args[i]);
                    continue;
                }
                throw new CLException("parse_args: Bad flag : " + name);
            }
            if (seenFileName) {
                throw new CLException("More than one file name given: " + fileName + " and " + arg);
            }
            fileName = arg;
            seenFileName = true;
        }
        return fileName;
    }

    public static void printUsage(Flags flags, String programName) throws Cvc3Exception {
        System.out.println("Usage: " + programName + " [options]");
        System.out.println(programName + " will read the input from STDIN and ");
        System.out.println("print the result on STDOUT.");
        System.out.println("Boolean (b) options are set 'on' by +option and 'off' by -option");
        System.out.println("(for instance, +sat or -sat).");
        System.out.println("Integer (i), string (s) and vector (v) options ");
        System.out.println("require a parameter, e.g. -width 80");
        System.out.println("Also, (v) options can appear multiple times setting args on and off,");
        System.out.println("as in +trace \"enable this\" -trace \"disable that\".");
        System.out.println("Option names can be abbreviated to the shortest unambiguous prefix.");
        System.out.println();
        System.out.println("The options are:");
        List names = flags.getFlags("");
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Flag flag = flags.getFlag(name);
            String prefix = "";
            if (flag.isNull()) {
                prefix = " (null)";
            } else if (flag.isBool()) {
                String enabled = flag.getBool() ? "+" : "-";
                prefix = " (b) " + enabled + name;
            } else if (flag.isInt()) {
                prefix = " (i) -" + name + " " + flag.getInt();
            } else if (flag.isString()) {
                prefix = " (s) -" + name + " " + flag.getString();
            } else if (flag.isStringVec()) {
                prefix = " (s) -" + name;
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            while (prefix.length() < 21) {
                prefix = prefix + " ";
            }
            System.out.println(prefix + " " + flag.getHelp());
        }
        System.out.println();
    }

    static {
        $assertionsDisabled = !Cvc3.class.desiredAssertionStatus();
        useObjManager = false;
    }
}

