(*****************************************************************************
/*!
 * \file meta_thms.ml
 *
 * Some theorems used in translation.  Most theorems act as meta-theorems 
 * 
 * <hr>
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * README file provided with this distribution.
 * 
 * <hr>
 * 
 */
/*****************************************************************************)


let REAL_NZ_RMUL = prove_by_refinement(
  `!x y z. (~(z = &0)) ==> (((x:real) = y) = (x * z = y * z))`,
  [
    ASM_MESON_TAC[REAL_EQ_MUL_RCANCEL];
  ]);;

let INT_NZ_RMUL = prove_by_refinement(
  `!x y z. (~(z:int = &0)) ==> (((x:int) = y) = (x * z = y * z))`,
  [
    ASM_MESON_TAC[INT_EQ_MUL_RCANCEL];
  ]);;

let REAL_UMINUS_TO_MULT = REAL_ARITH ` (-- a) = (-- & 1) * a` ;;
let INT_UMINUS_TO_MULT = INT_ARITH ` (-- a:int) = (-- & 1:int) * a` ;;

let lessThanEqRhs =  INT_ARITH `!x y. x:int < y <=> x <= y + (-- &1) ` ;;
let lessThanEqLhs = INT_LT_DISCRETE ;;

let rewrite_and_1 = TAUT `a/\T <=> a`;;
let rewrite_and_2 = TAUT `T/\a <=> a`;;
let rewrite_or_1 = TAUT `a\/F <=> a`;;
let rewrite_or_2 = TAUT `F\/a <=> a`;;

let rewrite_and_thm = TAUT `a/\(~ a) <=> F`;;
let rewrite_or_thm = TAUT `a \/( ~ a) <=> T`;;


let rw_flip_ineq_real_1 = REAL_ARITH `a:real > b <=> b < a`;;
let rw_flip_ineq_real_2 = REAL_ARITH `a:real >= b <=> b <= a`;;
let rw_flip_ineq_int_1 = INT_ARITH `a:int > b <=> b < a`;;
let rw_flip_ineq_int_2 = INT_ARITH `a:int >= b <=> b <= a`;;

let rw_neg_ineq_real_1 = prove(`(~(x:real > y)) = (x <= y)`,REAL_ARITH_TAC) ;;
let rw_neg_ineq_real_2 = prove(`(~(x:real < y)) = (x >= y)`,REAL_ARITH_TAC) ;;
let rw_neg_ineq_real_3 = prove(`(~(x:real <= y)) = (x > y)`,REAL_ARITH_TAC) ;;
let rw_neg_ineq_real_4 = prove(`(~(x:real >= y)) = (x < y)`,REAL_ARITH_TAC) ;;

let rw_neg_ineq_int_1 = prove(`(~(x:int > y)) = (x <= y)`,INT_ARITH_TAC) ;;
let rw_neg_ineq_int_2 = prove(`(~(x:int < y)) = (x >= y)`,INT_ARITH_TAC) ;;
let rw_neg_ineq_int_3 = prove(`(~(x:int <= y)) = (x > y)`,INT_ARITH_TAC) ;;
let rw_neg_ineq_int_4 = prove(`(~(x:int >= y)) = (x < y)`,INT_ARITH_TAC) ;;

let rw_right_minus_left_int_1 = prove(`(x:int < y) = (&0 < y - x)`,INT_ARITH_TAC) ;;
let rw_right_minus_left_int_2 = prove(`(x:int <= y) = (&0 <= y - x)`,INT_ARITH_TAC) ;;  
let rw_right_minus_left_int_3 = prove(`(x:int  > y) = (&0 > y - x)`,INT_ARITH_TAC) ;; 
let rw_right_minus_left_int_4 = prove(`(x:int  >= y) = (&0 >= y - x)`,INT_ARITH_TAC) ;;  
let rw_right_minus_left_int_5 = prove(`(x:int  = y) = (&0 = y - x)`,INT_ARITH_TAC) ;;

let rw_right_minus_left_real_1 = prove(`(x:real < y) = (&0 < y - x)`,REAL_ARITH_TAC) ;;
let rw_right_minus_left_real_2 = prove(`(x:real <= y) = (&0 <= y - x)`,REAL_ARITH_TAC) ;;  
let rw_right_minus_left_real_3 = prove(`(x:real  > y) = (&0 > y - x)`,REAL_ARITH_TAC) ;; 
let rw_right_minus_left_real_4 = prove(`(x:real  >= y) = (&0 >= y - x)`,REAL_ARITH_TAC) ;;  
let rw_right_minus_left_real_5 = prove(`(x:real  = y) = (&0 = y - x)`,REAL_ARITH_TAC) ;;


let lemma_minus_to_plus_int = INT_ARITH ` a:int - b = a + ((-- &1:int) * b)`  ;;
let lemma_minus_to_plus_real = INT_ARITH ` a:real - b = a + (-- &1 * b)`  ;;

let iff_th = TAUT `(a<=>b) <=> ((a==>b) /\ (b ==> a))` ;;

let lemma_or_exchange  = TAUT `(a \/ b <=> b\/a)`;;
let lemma_or_shift  = TAUT  `(a \/ b) \/ c <=>  a \/ ( b\/ c)`;;
let lemma_or_comb_both  = TAUT  `(a \/ b) \/ (a \/ c) <=>  a \/ ( b\/ c)`;;
let lemma_or_comb_left  = TAUT  `(a) \/ (a \/ c) <=>  ( a\/ c)`;;
let lemma_or_comb_right  = TAUT  `(a \/ b) \/ (a ) <=>  a \/ b`;;
let lemma_or_comb_nothing  = TAUT  `a  \/ a <=>  a `;;

let lemma_or_false_r  =  (TAUT  `a \/ F <=>  a `);;
let lemma_or_not_true_r  =  (TAUT  `a \/ ~T <=>  a `);;
let lemma_or_false_l  =  (TAUT  `F \/ a <=>  a `);;
let lemma_or_not_true_l  =  (TAUT  `~T \/ a <=>  a `);;

let lemma_le1 = prove(`~(x = &0) /\ ~(y = &0) <=> ~(x = &0) /\ ~(inv y = &0)`, REWRITE_TAC[REAL_INV_EQ_0]);; 
let lemma_le2 = TAUT `~(x = &0) /\ ~(inv y = &0) <=> ~((x = &0) \/ (inv y = &0))` ;;
let lemma_le3 = TRANS lemma_le1 lemma_le2;;
let lemma_le4 = prove ( `~((x = &0) \/ (inv y = &0)) <=> ~(x * (inv y ) = &0)` , REWRITE_TAC[REAL_ENTIRE]);;
let lemma_le5 = TRANS lemma_le3 lemma_le4;;
let lemma_le6 = prove(`~(x = &0) /\ ~(y = &0) <=> ~(x / y = &0)`, REWRITE_TAC[lemma_le5;real_div]);; 
let lemma_le7 = GEN_ALL lemma_le6;;

let lemma_ite_true  =   prove(`!e1 e2. (if T then e1 else e2) = e1`,REWRITE_TAC [COND_CLAUSES]) ;;
let lemma_ite_false =  prove(`!e1 e2. (if F then e1 else e2) = e2`,REWRITE_TAC [COND_CLAUSES]) ;;
let lemma_ite_same  = prove(` ! e b. (if e then b else b) = b ` , REWRITE_TAC[COND_ID]) ;;
let lemma_ite_same_iff  = prove(` ! e b. (if e then b else b) <=> b ` , REWRITE_TAC[COND_ID]) ;;

let lemma_var_intro = prove(` !y:A. ?x. y=x`, MESON_TAC[]);;

let lemma_rewrite_iff_symm = prove(` (a <=> b) <=> ( b <=>a)` ,MESON_TAC[]);; 
let lemma_rewrite_1 = prove(` ( T <=> e1) <=> e1`, MESON_TAC[]);;
let lemma_rewrite_2 = prove(` ( F <=> e1) <=> ~e1`, MESON_TAC[]);;
let lemma_rewrite_3 = prove(` ( e0 <=> T) <=> e0`, MESON_TAC[]);;
let lemma_rewrite_4 = prove(` ( e0 <=> F) <=> ~e0`, MESON_TAC[]);; 
let lemma_rewrite_5 = prove(` ( ~e1 <=> e1) <=> F`, MESON_TAC[]);; 
let lemma_rewrite_6 = prove(` ( e0 <=> ~e0) <=> F`, MESON_TAC[]);; 
let lemma_rewrite_iff_refl = prove ( `(a <=> a) <=> T` , MESON_TAC[]);;
let lemma_rewrite_not_ite = prove(` (~ (if (a:bool) then b else c)) <=> if a then (~b) else (~c)`, MESON_TAC[])   ;;
let lemma_rewrite_ite_true_iff = prove (` !e1 e2. (if T then e1 else e2) = e1`, MESON_TAC[]);; 
let lemma_rewrite_ite_false_iff = prove (` !e1 e2. (if F then e1 else e2) = e2`, MESON_TAC[]);;

let lemma_assup = TAUT `((a <=> b) ==> c) ==> a ==> b ==> c` ;;
let lemma_all_exists = prove (` (!x. p(x) ==> c) ==> ((?x.p(x)) ==> c) `, MESON_TAC[]);;  
    
let IMP_OR_THM_POS  = TAUT `(a ==> b) ==> ~a \/ b` ;;
let IMP_OR_THM_NEG  = TAUT `(~a ==> b) ==> a \/ b` ;;
let IMP_FALSE_THM_POS  = TAUT `(a ==> F ) ==> ~a ` ;;
let IMP_FALSE_THM_NEG  = TAUT `(~a ==> F ) ==> a ` ;;

let disj_neg_both =  TAUT ( ` (~ex \/ b) /\ (ex \/ c) ==> b \/c `) ;;
let disj_neg_right = TAUT ( ` (~ex ) /\ (ex \/ c ) ==> c `) ;;
let disj_neg_left = TAUT ( ` (~ex \/ b) /\ (ex ) ==> b  `);;
let disj_neg_nothing = TAUT ( ` (~ex ) /\ (ex ) ==> F `) ;;
let disj_pos_both = TAUT ( ` (ex \/ b) /\ (~ex \/ c) ==> b \/c `) ;;
let disj_pos_right = TAUT ( ` (ex ) /\ (~ex \/ c ) ==> c `) ;;
let disj_pos_left =  TAUT ( ` (ex \/ b) /\ (~ex ) ==> b  `) ;;
let disj_pos_nothing = TAUT ( ` (ex ) /\ (~ex ) ==> F `) ;;


let disj_imp_pos  = TAUT ` a\/b <=> ~a ==> b` ;;
let disj_imp_neg  = TAUT ` ~a\/b <=> a ==> b` ;;  
let disj_false_pos  = TAUT ` a <=> ~a ==> F` ;;
let disj_false_neg  = TAUT ` ~a <=> a ==> F` ;;  
 
let bool_final_pos = TAUT `(a ==> F) /\ (~a ==> F) ==> F` ;;
let bool_final_neg = TAUT `(~a ==> F) /\ (a ==>F) ==> F` ;;

let bool_final_pos_2 = TAUT `(a ==> F) <=> ((~a ==> F) <=> F)` ;;
let bool_final_neg_2 = TAUT `(~a ==> F) <=> ((a ==>F) <=> F)` ;;


let lemma_not_iff = TAUT ` ~a <=> (a <=> F)`;;

let lemma_if_lift_2_0 = TAUT `((p:A->A->B) (if a then b else c) x) = (if a then ( p b x) else (p c x))`;;
let lemma_if_lift_2_1 = TAUT `((p:A->A->B) x (if a then b else c)) = (if a then ( p x b) else (p x c))`;;

let SYMM_THM = prove(`!a b. (a:A = b) = (b = a)`,MESON_TAC[]);;

let lemma_not_true = prove(`~T = F`,REWRITE_TAC[]) ;; 
let lemma_not_false = prove(`~F = T`,REWRITE_TAC[]) ;; 
let lemma_rewrite_implies = TAUT `(a ==> b) = (~a \/ b)`
let lemma_not_not = prove(`!e. (~ ~ e) = e`,MESON_TAC[]) ;;
let lemma_iff_contro = TAUT `!p q. (p = q) = (~p = ~q)`;; 

(* lem9 -- lem12 are used in conflict_clause *)
let lem9__ = prove(`(a ==> b) <=> (~a \/ b)`,MESON_TAC[]);;
let lem10__ = prove(`(~ ~a) = a`,MESON_TAC[]);;
let lem11__ = prove(`(a \/ F) <=> a`,MESON_TAC[]);;
let lem12__ = prove(`(F \/ a) <=> a`,MESON_TAC[]);;

(*
let lem13__ = prove(`(a==>b) =( ~a\/b)`, MESON_TAC[]);;
let lem14__ = prove(`(a\/F) = a`,MESON_TAC[]);;
let lem15__ = prove(`(a=b) = (b=a)`, MESON_TAC[]);;

let rec collect_ors orFormula exTerm = 
  if orFormula = exTerm 
  then (true, [])
  else
    try
      let leftOr, rightOr = dest_or orFormula in
      let leftSucc, leftOrs = collect_ors leftOr exTerm in
      let rightSucc, rightOrs = collect_ors rightOr exTerm in
	(leftSucc or rightSucc, leftOrs @ rightOrs)
    with Failure _ -> (false,[orFormula]) ;;
*)
