(*****************************************************************************
/*!
 * \file alias.ml
 *
 * Short names of c_interface functions
 * 
 * <hr>
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * README file provided with this distribution.
 * 
 * <hr>
 * 
 */
/*****************************************************************************)


(* ====================================================================== *)
(*  Short names of c_interface functions                                  *) 
(* ====================================================================== *)

let reset =  ml_reset_error_status;;
let ges =  ml_get_error_sring;;

let getVC_nodagCVC() =  ml_vc_createValidityCheckerCVC false;;
let getVC_nodagSMT() =  ml_vc_createValidityCheckerSMT false;;
let destroy_cvc = ml_vc_destroyValidityChecker;;
let boolType = ml_vc_boolType;;
let realType = ml_vc_realType;;
let arrayType = ml_vc_arrayType;;
let intType = ml_vc_intType;;
let getEM = ml_vc_getEM;;
let getKindInt = ml_vc_getKindInt;;
let getKindString = ml_vc_getKindString;;
let varExpr = ml_vc_varExpr;;
let lookupVar = ml_vc_lookupVar;;
let getType = ml_vc_getType;;
(*let getOp = ml_vc_getOp;;*)
let getFun = ml_vc_getFun;;
let eqExpr = ml_vc_eqExpr;;
let trueExpr = ml_vc_trueExpr;;
let falseExpr = ml_vc_falseExpr;;
let notExpr = ml_vc_notExpr;;
let andExpr = ml_vc_andExpr;;
let orExpr = ml_vc_orExpr;;
let impliesExpr = ml_vc_impliesExpr;;
let iffExpr = ml_vc_iffExpr;;
let iteExpr = ml_vc_iteExpr;;
let ratExpr = ml_vc_ratExpr;;
let ratExprFromStr = ml_vc_ratExprFromStr;;
let uminusExpr = ml_vc_uminusExpr;;
let plusExpr = ml_vc_plusExpr;;
let minusExpr = ml_vc_minusExpr;;
let multExpr = ml_vc_multExpr;;
let powExpr = ml_vc_powExpr;;
let divideExpr = ml_vc_divideExpr;;
let ltExpr = ml_vc_ltExpr;;
let leExpr = ml_vc_leExpr;;
let gtExpr = ml_vc_gtExpr;;
let geExpr = ml_vc_geExpr;;
let assertFormula = ml_vc_assertFormula;;
let simplify = ml_vc_simplify;;
let query = ml_vc_query;;
let getProof = ml_vc_getProof;;
let getAssumptions = ml_vc_getProofAssumptions;;
let getQuery = ml_vc_getProofQuery;;
let exprString = ml_expr_toString;;
let typeString = ml_type_toString;;
let arity = ml_expr_arity;;

let child exp n = (* Set guards here *)  
  if n > (arity exp - 1) or n < 0 
  then  failwith ("out of bound" ^ (string_of_int n)) 
  else ml_expr_child exp n;;

let kind = ml_expr_getKind;;
let isClosure = ml_expr_isClosure;;
let isQuantifier = ml_expr_isQuantifier;;
let readExpr = ml_vc_readExpr;;
let writeExpr = ml_vc_writeExpr;;
let getNumVars = ml_expr_getNumVars;;
let getVar = ml_expr_getVar;;
let getBody = ml_expr_getBody;;
let getExistential = ml_expr_getExistential;;
let toExpr = ml_type_toExpr;;
let typeToExpr = toExpr;;
let isVar = ml_expr_isVar;;
let typeExpr vc = toExpr o (getType vc);;
let getInt = ml_expr_getInt;;
let compare_exprs = ml_expr_compare;;
let kind_string vc exp = getKindString vc (kind exp);;
let getTypeString vc exp = typeString (getType vc exp);;
let isLambda vc exp = kind_string vc exp = "_LAMBDA";;
