/*
 * Decompiled with CFR 0.152.
 */
package cvc3;

import cvc3.Cvc3Exception;
import cvc3.DebugException;
import cvc3.Expr;
import cvc3.ExprMut;
import cvc3.FlagsMut;
import cvc3.Op;
import cvc3.OpMut;
import cvc3.QueryResult;
import cvc3.Rational;
import cvc3.Type;
import cvc3.TypeMut;
import cvc3.TypecheckException;
import cvc3.ValidityChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class Test {
    static final /* synthetic */ boolean $assertionsDisabled;

    Test() {
    }

    public static void main(String[] args) {
        int regressLevel = 3;
        if (args.length > 1) {
            regressLevel = Integer.parseInt(args[0]);
        }
        boolean allPassed = true;
        System.out.println("Running API test, regress level = " + regressLevel);
        try {
            System.out.println("\ntest():");
            allPassed = Test.test() && allPassed;
            System.out.println("\n}\ntest1():");
            allPassed = Test.test1() && allPassed;
            System.out.println("\n}\ntest2():");
            allPassed = Test.test2() && allPassed;
            System.out.println("\n}\ntest3():");
            allPassed = Test.test3() && allPassed;
            System.out.println("\n}\ntest4():");
            boolean bl = allPassed = Test.test4() && allPassed;
            if (regressLevel > 0) {
                System.out.println("\n}\n\ntest5():");
                allPassed = Test.test5() && allPassed;
            }
            System.out.println("\n}\ntest6():");
            allPassed = Test.test6() && allPassed;
            System.out.println("\n}\ntest7():");
            allPassed = Test.test7() && allPassed;
            System.out.println("\n}\ntest8():");
            allPassed = Test.test8() && allPassed;
            System.out.println("\n}\ntest9():");
            allPassed = Test.test9(10 * regressLevel + 10) && allPassed;
            System.out.println("\n}\nbvtest9():");
            allPassed = Test.bvtest9(regressLevel * 3 + 2) && allPassed;
            int limit = 100 * regressLevel + 10;
            for (int i = 0; i < limit; ++i) {
                if (i % 100 == 0) {
                    System.out.println("test10[" + i + "]");
                }
                allPassed = Test.test10() && allPassed;
            }
            System.out.println("\n}\ntest11():");
            allPassed = Test.test11() && allPassed;
            System.out.println("\n}\ntest12():");
            allPassed = Test.test12() && allPassed;
            System.out.println("\n}\ntest13():");
            allPassed = Test.test13() && allPassed;
            System.out.println("\n}\ntest14():");
            allPassed = Test.test14() && allPassed;
            System.out.println("\n}\ntest15():");
            allPassed = Test.test15() && allPassed;
            System.out.println("\n}\ntest16():");
            allPassed = Test.test16() && allPassed;
            System.out.println("\n}\ntest17():");
            allPassed = Test.test17() && allPassed;
            System.out.println("\n}\ntest18():");
            allPassed = Test.test18() && allPassed;
            System.out.println("\n}\ntest19():");
            allPassed = Test.test19() && allPassed;
            System.out.println("\n}\ntest22():");
            allPassed = Test.test22() && allPassed;
            System.out.println("\n}\ntest23():");
            allPassed = Test.test23() && allPassed;
            System.out.println("\n}\ntestNonlinearBV():");
            allPassed = Test.testNonlinearBV() && allPassed;
            System.out.println("\n}\ntestDistinct():");
            allPassed = Test.testDistinct() && allPassed;
            System.out.println("\n}");
        }
        catch (Exception e) {
            System.out.println("*** Exception caught: \n" + e);
            e.printStackTrace(System.out);
            allPassed = false;
        }
        if (allPassed) {
            System.out.println("Program exits successfully.");
        } else {
            System.out.println("Program exits with error status = " + allPassed + ".");
        }
        System.exit(allPassed ? 0 : 1);
    }

    public static void DebugAssert(boolean condition, String message) throws Cvc3Exception {
        if (!condition) {
            throw new DebugException(message);
        }
    }

    public static boolean check(ValidityChecker vc, Expr e) throws Cvc3Exception {
        return Test.check(vc, e, true);
    }

    public static boolean check(ValidityChecker vc, Expr e, boolean verbose) throws Cvc3Exception {
        QueryResult result;
        if (verbose) {
            System.out.println("Query: " + e.toString());
        }
        if ((result = vc.query(e)) == QueryResult.VALID) {
            if (verbose) {
                System.out.println("Valid\n");
            }
            return true;
        }
        if (result == QueryResult.INVALID) {
            if (verbose) {
                System.out.println("Invalid\n");
            }
            return false;
        }
        if (verbose) {
            System.out.println("Returned neither valid nor invalid\n");
        }
        return false;
    }

    public static void printResult(QueryResult result) throws Cvc3Exception {
        if (result == QueryResult.VALID) {
            System.out.println("Result Valid");
        } else if (result == QueryResult.INVALID) {
            System.out.println("Result Invalid");
        } else if (result == QueryResult.UNKNOWN) {
            System.out.println("Result Unknown");
        } else if (result == QueryResult.ABORT) {
            System.out.println("Aborted");
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public static void newAssertion(ValidityChecker vc, Expr e) throws Cvc3Exception {
        System.out.println("Assert: " + e);
        vc.assertFormula(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test() throws Cvc3Exception {
        ValidityChecker vc = null;
        try {
            vc = ValidityChecker.create();
            TypeMut it = vc.intType();
            OpMut f = vc.createOp("f", vc.funType(it, (Type)it));
            ExprMut z = vc.varExpr("z", it);
            Expr e = vc.funExpr((Op)f, vc.funExpr((Op)f, z));
            e = e.getChild(0);
            ExprMut f2 = vc.funExpr((Op)f, e);
            ExprMut f3 = vc.funExpr((Op)f, f2);
            Test.DebugAssert(!e.equals(f2) && !e.equals(f3), "Refcount problems");
            ExprMut x = vc.boundVarExpr("x", "0", it);
            ArrayList<ExprMut> xs = new ArrayList<ExprMut>();
            xs.add(x);
            OpMut lxsx = vc.lambdaExpr(xs, x);
            ExprMut y = vc.ratExpr(1, 1);
            ArrayList<ExprMut> ys = new ArrayList<ExprMut>();
            ys.add(y);
            ExprMut lxsxy = vc.funExpr((Op)lxsx, y);
            ExprMut lxsxys = vc.funExpr((Op)lxsx, ys);
            System.out.println("Lambda application: " + lxsxy);
            System.out.println("Simplified: " + vc.simplify(lxsxy));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test1() throws Cvc3Exception {
        ValidityChecker vc = null;
        FlagsMut flags = null;
        try {
            flags = ValidityChecker.createFlags(null);
            flags.setFlag("dagify-exprs", false);
            flags.setFlag("dump-log", ".test1.cvc");
            vc = ValidityChecker.create(flags);
            boolean b = Test.check(vc, vc.trueExpr());
            Test.DebugAssert(b, "Should be valid");
            vc.push();
            b = Test.check(vc, vc.falseExpr());
            Test.DebugAssert(!b, "Should be invalid");
            vc.pop();
            ExprMut p = vc.varExpr("p", vc.boolType());
            ExprMut e = vc.orExpr(p, vc.notExpr(p));
            b = Test.check(vc, e);
            Test.DebugAssert(b, "Should be valid");
            ExprMut x = vc.varExpr("x", vc.realType());
            ExprMut y = vc.varExpr("y", vc.realType());
            TypeMut real2real = vc.funType(vc.realType(), (Type)vc.realType());
            OpMut f = vc.createOp("f", real2real);
            ExprMut fx = vc.funExpr((Op)f, x);
            ExprMut fy = vc.funExpr((Op)f, y);
            e = vc.impliesExpr(vc.eqExpr(x, y), vc.eqExpr(fx, fy));
            b = Test.check(vc, e);
            Test.DebugAssert(b, "Should be valid");
            e = vc.impliesExpr(vc.eqExpr(fx, fy), vc.eqExpr(x, y));
            int scopeLevel = vc.scopeLevel();
            vc.push();
            b = Test.check(vc, e);
            Test.DebugAssert(!b, "Should be invalid");
            System.out.println("Scope level: " + vc.scopeLevel());
            System.out.println("Counter-example:");
            List assertions = vc.getCounterExample();
            for (int i = 0; i < assertions.size(); ++i) {
                System.out.println((Expr)assertions.get(i));
            }
            System.out.println("End of counter-example");
            System.out.println();
            System.out.println("Resetting");
            vc.pop();
            Test.DebugAssert(scopeLevel == vc.scopeLevel(), "scope error");
            System.out.println("Scope level: " + vc.scopeLevel());
            System.out.println();
            ExprMut w = vc.varExpr("w", vc.realType());
            ExprMut z = vc.varExpr("z", vc.realType());
            System.out.println("Push Scope");
            System.out.println();
            vc.push();
            Test.newAssertion(vc, vc.eqExpr(w, x));
            Test.newAssertion(vc, vc.eqExpr(x, y));
            Test.newAssertion(vc, vc.eqExpr(y, z));
            Test.newAssertion(vc, vc.eqExpr(fx, fy));
            Test.newAssertion(vc, vc.eqExpr(x, vc.ratExpr(1)));
            System.out.println("simplify(w) = " + vc.simplify(w));
            Test.DebugAssert(vc.simplify(w).equals(vc.ratExpr(1)), "Expected simplify(w) = 1");
            Test.newAssertion(vc, vc.eqExpr(z, vc.ratExpr(2)));
            System.out.println("Inconsistent?: " + vc.inconsistent());
            System.out.println("Assumptions Used:");
            assertions = vc.inconsistentReasons();
            for (int i = 0; i < assertions.size(); ++i) {
                System.out.println((Expr)assertions.get(i));
            }
            System.out.println("Pop Scope");
            System.out.println();
            vc.pop();
            System.out.println("simplify(w) = " + vc.simplify(w));
            Test.DebugAssert(vc.simplify(w).equals(w), "Expected simplify(w) = w");
            System.out.println("Inconsistent?: " + vc.inconsistent());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test1(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
            if (flags != null) {
                flags.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test2() throws Cvc3Exception {
        ValidityChecker vc = null;
        FlagsMut flags = null;
        try {
            flags = ValidityChecker.createFlags(null);
            flags.setFlag("dagify-exprs", false);
            vc = ValidityChecker.create(flags);
            ExprMut bexpr = vc.varExpr("b", vc.intType());
            vc.assertFormula(vc.ltExpr(bexpr, vc.ratExpr(10)));
            ExprMut c = vc.varExpr("c", vc.intType());
            vc.assertFormula(vc.orExpr(vc.eqExpr(c, vc.ratExpr(0)), vc.eqExpr(c, vc.ratExpr(1))));
            boolean b = Test.check(vc, vc.leExpr(bexpr, vc.ratExpr(10)));
            Test.DebugAssert(b, "Should be valid");
            b = Test.check(vc, vc.falseExpr());
            Test.DebugAssert(!b, "Should be invalid");
            vc.returnFromCheck();
            ExprMut x = vc.varExpr("x", vc.realType());
            ExprMut y = vc.varExpr("y", vc.realType());
            TypeMut real = vc.realType();
            ArrayList<TypeMut> RxR = new ArrayList<TypeMut>();
            RxR.add(real);
            RxR.add(real);
            TypeMut realxreal2real = vc.funType(RxR, (Type)real);
            OpMut g = vc.createOp("g", realxreal2real);
            ExprMut gxy = vc.funExpr(g, x, y);
            ExprMut gyx = vc.funExpr(g, y, x);
            ExprMut e = vc.impliesExpr(vc.eqExpr(x, y), vc.eqExpr(gxy, gyx));
            b = Test.check(vc, e);
            Test.DebugAssert(b, "Should be valid");
            OpMut h = vc.createOp("h", realxreal2real);
            ExprMut hxy = vc.funExpr(h, x, y);
            ExprMut hyx = vc.funExpr(h, y, x);
            e = vc.impliesExpr(vc.eqExpr(x, y), vc.eqExpr(hxy, hyx));
            b = Test.check(vc, e);
            Test.DebugAssert(b, "Should be valid");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test2(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
            if (flags != null) {
                flags.delete();
            }
        }
    }

    public static ExprMut ltLex(ValidityChecker vc, Expr i1, Expr i2, Expr j1, Expr j2) throws Cvc3Exception {
        ExprMut res = vc.ltExpr(i1, j1);
        return vc.orExpr(res, vc.andExpr(vc.eqExpr(i1, j1), vc.ltExpr(i2, j2)));
    }

    public static ExprMut createTestFormula(ValidityChecker vc, Expr i1, Expr i2, Expr r1, Expr r2) throws Cvc3Exception {
        ExprMut lt1 = Test.ltLex(vc, r1, r2, i1, i2);
        ExprMut lt2 = Test.ltLex(vc, i2, i1, r2, r1);
        return vc.andExpr(lt1, lt2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test3() throws Cvc3Exception {
        ValidityChecker vc = null;
        FlagsMut flags = null;
        try {
            flags = ValidityChecker.createFlags(null);
            flags.setFlag("dagify-exprs", false);
            vc = ValidityChecker.create(flags);
            ExprMut i = vc.varExpr("i", vc.realType());
            ExprMut j = vc.varExpr("j", vc.realType());
            ExprMut k = vc.varExpr("k", vc.realType());
            ExprMut one = vc.ratExpr(1);
            ExprMut test = Test.createTestFormula(vc, i, j, vc.minusExpr(i, one), vc.minusExpr(j, k));
            System.out.println("Trying test: " + test);
            vc.push();
            QueryResult result = vc.query(test);
            if (result == QueryResult.VALID) {
                System.out.println("Test Valid");
                vc.pop();
            } else {
                int index;
                List assertions = vc.getCounterExample();
                System.out.println("Test Invalid Under Conditions:");
                for (index = 0; index < assertions.size(); ++index) {
                    System.out.println(assertions.get(index));
                }
                for (index = 0; index < assertions.size(); ++index) {
                    ExprMut condition = vc.notExpr((Expr)assertions.get(index));
                    System.out.println("Trying test under condition: " + condition);
                    vc.pop();
                    vc.push();
                    Test.printResult(vc.query(vc.impliesExpr(condition, test)));
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test3(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
            if (flags != null) {
                flags.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test4() throws Cvc3Exception {
        ValidityChecker vc = null;
        FlagsMut flags = null;
        try {
            flags = ValidityChecker.createFlags(null);
            flags.setFlag("dagify-exprs", false);
            vc = ValidityChecker.create(flags);
            ExprMut i = vc.varExpr("i", vc.realType());
            ExprMut j = vc.varExpr("j", vc.realType());
            ExprMut k = vc.varExpr("k", vc.realType());
            ExprMut one = vc.ratExpr(1);
            ExprMut test = Test.createTestFormula(vc, i, j, vc.minusExpr(i, one), vc.minusExpr(j, k));
            System.out.println("Trying test: " + test);
            vc.push();
            QueryResult result = vc.query(test);
            if (result == QueryResult.VALID) {
                System.out.println("Test Valid");
            } else {
                int index;
                List assertions = vc.getCounterExample();
                System.out.println("Test Invalid Under Conditions:");
                for (index = 0; index < assertions.size(); ++index) {
                    System.out.println(assertions.get(index));
                }
                for (index = 0; index < assertions.size(); ++index) {
                    ExprMut condition = vc.notExpr((Expr)assertions.get(index));
                    System.out.println("Trying test under condition: " + condition);
                    vc.pop();
                    vc.push();
                    Test.printResult(vc.query(vc.impliesExpr(condition, test)));
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test4(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
            if (flags != null) {
                flags.delete();
            }
        }
    }

    public static void findLeaves(Expr e, List l) throws Cvc3Exception {
        int ar = e.arity();
        if (ar > 0) {
            for (int i = 0; i < ar; ++i) {
                Test.findLeaves(e.getChild(i), l);
            }
            return;
        }
        l.add(e);
    }

    public static boolean hasij(Expr e, Expr i, Expr j) throws Cvc3Exception {
        int ar = e.arity();
        if (ar > 0) {
            for (int k = 0; k < ar; ++k) {
                if (!Test.hasij(e.getChild(k), i, j)) continue;
                return true;
            }
            return false;
        }
        return e.equals(i) || e.equals(j);
    }

    public static Expr plusExpr(ValidityChecker vc, List kids) throws Cvc3Exception {
        if (kids.size() == 0) {
            return vc.ratExpr(0);
        }
        if (kids.size() == 1) {
            return (Expr)kids.get(0);
        }
        if (kids.size() == 2) {
            return vc.plusExpr((Expr)kids.get(0), (Expr)kids.get(1));
        }
        Expr r = (Expr)kids.get(kids.size() - 1);
        kids.remove(kids.size() - 1);
        return vc.plusExpr(Test.plusExpr(vc, kids), r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test5() throws Cvc3Exception {
        ValidityChecker vc = null;
        FlagsMut flags = null;
        try {
            flags = ValidityChecker.createFlags(null);
            flags.setFlag("dagify-exprs", false);
            vc = ValidityChecker.create(flags);
            ExprMut i = vc.varExpr("i1", vc.realType());
            ExprMut j = vc.varExpr("i2", vc.realType());
            ExprMut p = vc.varExpr("p", vc.realType());
            ExprMut q = vc.varExpr("q", vc.realType());
            ExprMut r = vc.varExpr("r", vc.realType());
            ExprMut a = vc.varExpr("arb_addr", vc.realType());
            ExprMut N = vc.varExpr("N", vc.realType());
            ExprMut M = vc.varExpr("M", vc.arrayType(vc.realType(), vc.realType()));
            ExprMut M2 = vc.writeExpr(M, vc.plusExpr(q, i), vc.readExpr(M, vc.plusExpr(r, i)));
            ExprMut M1 = vc.writeExpr(M, vc.plusExpr(p, j), vc.readExpr(M, vc.plusExpr(r, j)));
            Expr e = vc.eqExpr(vc.readExpr(vc.writeExpr(M2, vc.plusExpr(p, j), vc.readExpr(M2, vc.plusExpr(r, j))), a), vc.readExpr(vc.writeExpr(M1, vc.plusExpr(q, i), vc.readExpr(M1, vc.plusExpr(r, i))), a));
            ExprMut one = vc.ratExpr(1);
            ExprMut zero = vc.ratExpr(0);
            ExprMut qmp = vc.minusExpr(q, p);
            ExprMut qmr = vc.minusExpr(q, r);
            ArrayList<ExprMut> hyp = new ArrayList<ExprMut>();
            hyp.add(vc.ltExpr(i, j));
            ExprMut test = vc.impliesExpr(vc.andExpr(hyp), e);
            System.out.println("Checking verification condition:" + test);
            vc.push();
            QueryResult result = vc.query(test);
            if (result == QueryResult.VALID) {
                System.out.println("Test Valid");
            } else {
                int index;
                int index2;
                ArrayList<ExprMut> conditions = new ArrayList<ExprMut>();
                List assertions = vc.getCounterExample();
                System.out.println("Invalid Under Conditions:");
                for (index2 = 0; index2 < assertions.size(); ++index2) {
                    if (!((Expr)assertions.get(index2)).equals(vc.notExpr(test))) continue;
                    while (index2 < assertions.size() - 1) {
                        assertions.set(index2, assertions.get(index2 + 1));
                        ++index2;
                    }
                    assertions.remove(assertions.size() - 1);
                    break;
                }
                for (index2 = 0; index2 < assertions.size(); ++index2) {
                    System.out.println(assertions.get(index2));
                }
                System.out.println();
                for (index2 = 0; index2 < assertions.size(); ++index2) {
                    int index22;
                    e = (Expr)assertions.get(index2);
                    if (e.isNot()) {
                        System.out.println("Condition ineligible: negation: " + e);
                        System.out.println();
                        continue;
                    }
                    int req = e.isEq() ? 2 : 1;
                    ArrayList leaves = new ArrayList();
                    Test.findLeaves(e, leaves);
                    for (index22 = 0; index22 < leaves.size(); ++index22) {
                        if (!((Expr)leaves.get(index22)).isVar() || ((Expr)leaves.get(index22)).equals(i) || ((Expr)leaves.get(index22)).equals(j) || ((Expr)leaves.get(index22)).equals(a)) continue;
                        --req;
                    }
                    if (req > 0) {
                        System.out.println("Condition ineligible: not enough non-loop variables: " + e);
                        System.out.println();
                        continue;
                    }
                    System.out.println("Condition selected: " + e);
                    System.out.println();
                    conditions.add(vc.notExpr(e));
                    System.out.println("Trying verification condition with hypothesis: " + vc.andExpr(conditions));
                    vc.pop();
                    vc.push();
                    ExprMut query = vc.impliesExpr(vc.andExpr(conditions), test);
                    result = vc.query(test);
                    if (result == QueryResult.VALID) {
                        System.out.println("Result Valid");
                        break;
                    }
                    assertions = vc.getCounterExample();
                    System.out.println("Invalid Under Conditions:");
                    for (index22 = 0; index22 < assertions.size(); ++index22) {
                        if (!((Expr)assertions.get(index22)).equals(vc.notExpr(query))) continue;
                        while (index22 < assertions.size() - 1) {
                            assertions.set(index22, assertions.get(index22 + 1));
                            ++index22;
                        }
                        assertions.remove(assertions.size() - 1);
                        break;
                    }
                    for (index22 = 0; index22 < assertions.size(); ++index22) {
                        System.out.println(assertions.get(index22));
                    }
                    System.out.println();
                    index2 = assertions.size();
                }
                System.out.println();
                System.out.println("Attempting to remove loop variables");
                ArrayList<ExprMut> newConditions = new ArrayList<ExprMut>();
                ArrayList<Expr> newPlus = new ArrayList<Expr>();
                ExprMut minusone = vc.ratExpr(-1);
                for (index = 0; index < conditions.size(); ++index) {
                    if (((Expr)conditions.get(index)).getChild(0).isEq() && Test.hasij(e = vc.simplify(vc.minusExpr(((Expr)conditions.get(index)).getChild(0).getChild(0), ((Expr)conditions.get(index)).getChild(0).getChild(1))), i, j)) {
                        if (e.isPlus()) {
                            newPlus.clear();
                            newPlus.add(e.getChild(0));
                            boolean negj = false;
                            boolean negi = false;
                            boolean foundj = false;
                            boolean foundi = false;
                            for (int index23 = 1; index23 < e.arity(); ++index23) {
                                Expr term = e.getChild(index23);
                                if (term.equals(i) && !foundi) {
                                    foundi = true;
                                    continue;
                                }
                                if (term.equals(j) && !foundj) {
                                    foundj = true;
                                    negj = true;
                                    continue;
                                }
                                if (term.isMult() && term.getChild(0).equals(minusone) && term.getChild(1).equals(i) && !foundi) {
                                    foundi = true;
                                    negi = true;
                                    continue;
                                }
                                if (term.isMult() && term.getChild(0).equals(minusone) && term.getChild(1).equals(j) && !foundj) {
                                    foundj = true;
                                    continue;
                                }
                                newPlus.add(term);
                            }
                            if (foundi && foundj && (negi && negj || !negi && !negj)) {
                                e = Test.plusExpr(vc, newPlus);
                                if (negi && negj) {
                                    e = vc.uminusExpr(e);
                                }
                                if (!Test.hasij(e = vc.simplify(e), i, j)) {
                                    newConditions.add(vc.orExpr(vc.geExpr(e, N), vc.leExpr(e, zero)));
                                    continue;
                                }
                            }
                        }
                        System.out.println("Unable to remove loop variables:" + e);
                        break;
                    }
                    newConditions.add((ExprMut)conditions.get(index));
                }
                if (index == conditions.size()) {
                    System.out.println("Loop variables successfully removed:");
                    ExprMut cond = newConditions.size() > 0 ? vc.andExpr(newConditions) : vc.trueExpr();
                    System.out.println(cond);
                    ArrayList<ExprMut> loopConditions = new ArrayList<ExprMut>();
                    loopConditions.add(cond);
                    loopConditions.add(vc.geExpr(i, one));
                    loopConditions.add(vc.geExpr(j, one));
                    loopConditions.add(vc.leExpr(i, N));
                    loopConditions.add(vc.leExpr(j, N));
                    vc.pop();
                    vc.push();
                    System.out.println("Final query");
                    Test.printResult(vc.query(vc.impliesExpr(vc.andExpr(loopConditions), test)));
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test5(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
            if (flags != null) {
                flags.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test6() throws Cvc3Exception {
        ValidityChecker vc1 = null;
        ValidityChecker vc2 = null;
        try {
            vc1 = ValidityChecker.create();
            vc2 = ValidityChecker.create();
            TypeMut real1 = vc1.realType();
            ExprMut x1 = vc1.varExpr("x", real1);
            ExprMut y1 = vc1.boundVarExpr("y", "0", real1);
            System.out.println("vc1 variables: " + x1 + ", " + y1);
            ExprMut x2 = vc2.varExpr("x", vc2.importType(real1));
            ExprMut y2 = vc2.boundVarExpr("y", "0", vc2.realType());
            System.out.println("vc2 variables: " + x2 + ", " + y2);
            System.out.println("vars imported to vc2 from vc1: " + vc2.importExpr(x1) + ", " + vc2.importExpr(y1));
            ExprMut t1 = vc1.trueExpr();
            ExprMut and1 = vc1.andExpr(t1, vc1.falseExpr());
            OpMut f1 = vc1.createOp("f", vc1.funType(real1, (Type)real1));
            ExprMut fx1 = vc1.funExpr((Op)f1, x1);
            ExprMut f5_1 = vc1.funExpr((Op)f1, vc1.ratExpr(5, 1));
            TypeMut rt1 = vc1.recordType("foo", real1, "bar", real1);
            ExprMut r1 = vc1.recordExpr("foo", fx1, "bar", f5_1);
            ExprMut r1_eq = vc1.eqExpr(r1, vc1.recUpdateExpr(r1, "foo", f5_1));
            TypeMut art1 = vc1.arrayType(real1, rt1);
            ExprMut ar1 = vc1.varExpr("ar", art1);
            ExprMut ar_eq1 = vc1.eqExpr(vc1.writeExpr(ar1, x1, r1), ar1);
            ExprMut query1 = vc1.eqExpr(vc1.recSelectExpr(vc1.readExpr(ar1, x1), "foo"), vc1.recSelectExpr(r1, "bar"));
            System.out.println("*** VC #1:");
            Test.newAssertion(vc1, r1_eq);
            Test.newAssertion(vc1, ar_eq1);
            Test.check(vc1, query1);
            System.out.println("*** VC #2:");
            Test.newAssertion(vc2, vc2.importExpr(r1_eq));
            Test.newAssertion(vc2, vc2.importExpr(ar_eq1));
            Test.check(vc2, vc2.importExpr(query1));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test6(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc1 != null) {
                vc1.delete();
            }
            if (vc2 != null) {
                vc2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test7() throws Cvc3Exception {
        ValidityChecker vc1 = null;
        ValidityChecker vc2 = null;
        try {
            vc1 = ValidityChecker.create();
            vc2 = ValidityChecker.create();
            ExprMut e1 = vc1.varExpr("e1", vc1.realType());
            ExprMut e2 = vc2.varExpr("e2", vc2.realType());
            Test.newAssertion(vc2, vc2.eqExpr(vc2.importExpr(e1), e2));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test7(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc1 != null) {
                vc1.delete();
            }
            if (vc2 != null) {
                vc2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test8() throws Cvc3Exception {
        ValidityChecker vc = null;
        try {
            vc = ValidityChecker.create();
            ArrayList<ExprMut> vec = new ArrayList<ExprMut>();
            vec.add(vc.boundVarExpr("x", "x", vc.realType()));
            ExprMut lambda = vc.lambdaExpr(vec, vc.falseExpr()).getExpr();
            try {
                TypeMut t = vc.subtypeType(lambda, vc.nullExpr());
                Test.DebugAssert(false, "Typechecking exception expected");
            }
            catch (TypecheckException typecheckException) {
                // empty catch block
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test5(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
        }
    }

    public static ExprMut adder(ValidityChecker vc, Expr a, Expr b, Expr c) throws Cvc3Exception {
        return vc.notExpr(vc.iffExpr(vc.notExpr(vc.iffExpr(a, b)), c));
    }

    public static ExprMut carry(ValidityChecker vc, Expr a, Expr b, Expr c) throws Cvc3Exception {
        return vc.orExpr(vc.andExpr(a, b), vc.orExpr(vc.andExpr(b, c), vc.andExpr(a, c)));
    }

    public static List add(ValidityChecker vc, List a, List b) throws Cvc3Exception {
        int N = a.size();
        ExprMut c = vc.falseExpr();
        ArrayList<ExprMut> sum = new ArrayList<ExprMut>();
        for (int i = 0; i < N; ++i) {
            sum.add(Test.adder(vc, (Expr)a.get(i), (Expr)b.get(i), c));
            c = Test.carry(vc, (Expr)a.get(i), (Expr)b.get(i), c);
        }
        return sum;
    }

    public static ExprMut vectorEq(ValidityChecker vc, List a, List b) throws Cvc3Exception {
        int N = a.size();
        ExprMut result = vc.trueExpr();
        for (int i = 0; i < N; ++i) {
            result = vc.andExpr(result, vc.iffExpr((Expr)a.get(i), (Expr)b.get(i)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test9(int N) throws Cvc3Exception {
        ValidityChecker vc = null;
        try {
            vc = ValidityChecker.create();
            ArrayList<ExprMut> a = new ArrayList<ExprMut>();
            ArrayList<ExprMut> b = new ArrayList<ExprMut>();
            for (int i = 0; i < N; ++i) {
                a.add(vc.varExpr("a" + Integer.toString(i), vc.boolType()));
                b.add(vc.varExpr("b" + Integer.toString(i), vc.boolType()));
            }
            List sum1 = Test.add(vc, a, b);
            List sum2 = Test.add(vc, b, a);
            ExprMut q = Test.vectorEq(vc, sum1, sum2);
            Test.check(vc, q);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test9(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test22() throws Cvc3Exception {
        ValidityChecker vc = null;
        try {
            vc = ValidityChecker.create();
            TypeMut intType = vc.intType();
            TypeMut fType = vc.funType(intType, (Type)intType);
            OpMut f = vc.createOp("f", fType);
            ExprMut x = vc.varExpr("x", intType);
            ExprMut fx = vc.exprFromString("f(x)");
            ExprMut p = vc.exprFromString("FORALL (x:INT) : x < f(x)");
            ArrayList patternvv = new ArrayList();
            ArrayList<ExprMut> patternv = new ArrayList<ExprMut>();
            patternv.add(fx);
            patternvv.add(patternv);
            vc.setTriggers(p, patternv);
            Test.DebugAssert(((Object)patternvv).equals(p.getTriggers()), "Expected p.getTriggers() == patternvv: " + p.toString());
            vc.setMultiTriggers(p, patternvv);
            Test.DebugAssert(((Object)patternvv).equals(p.getTriggers()), "Expected p.getTriggers() == patternvv: " + p.toString());
            ArrayList<ExprMut> vars = new ArrayList<ExprMut>();
            vars.add(x);
            ExprMut r = vc.forallExpr(vars, (Expr)vc.ltExpr(x, fx), patternv);
            Test.DebugAssert(((Object)patternvv).equals(r.getTriggers()), "Expected r.getTriggers() == patternvv: " + r.toString());
            ExprMut s = vc.exprFromString("FORALL (x:INT) : x > f(x)");
            vc.setTrigger(s, fx);
            List trigsvv = s.getTriggers();
            Test.DebugAssert(trigsvv.size() == 1, "Expected s.getTriggers().size() == 1: " + trigsvv.size());
            List trigsv = (List)trigsvv.get(0);
            Test.DebugAssert(trigsv.size() == 1, "Expected s.getTriggers()[0].size() == 1: " + trigsv.size());
            Test.DebugAssert(fx.equals(trigsv.get(0)), "Expected s.getTriggers()[0][0] == fx: " + trigsv.get(0));
            ExprMut t = vc.exprFromString("FORALL (x:INT) : x > f(x)");
            vc.setMultiTrigger(t, patternv);
            trigsvv = t.getTriggers();
            Test.DebugAssert(trigsvv.size() == 1, "Expected t.getTriggers().size() == 1: " + trigsvv.size());
            trigsv = (List)trigsvv.get(0);
            Test.DebugAssert(trigsv.size() == 1, "Expected t.getTriggers()[0].size() == 1: " + trigsv.size());
            Test.DebugAssert(fx.equals(trigsv.get(0)), "Expected t.getTriggers()[0][0] == fx: " + trigsv.get(0));
            ExprMut u = vc.forallExprMultiTriggers(vars, vc.ltExpr(x, fx), patternvv);
            Test.DebugAssert(((Object)patternvv).equals(u.getTriggers()), "Expected u.getTriggers() == patternvv: " + u.toString());
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test22(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean test23() throws Cvc3Exception {
        ValidityChecker vc = null;
        try {
            vc = ValidityChecker.create();
            TypeMut intType = vc.intType();
            ExprMut x = vc.varExpr("x", intType);
            ExprMut y = vc.varExpr("y", intType);
            ExprMut a = vc.varExpr("a", intType);
            ExprMut b = vc.varExpr("b", intType);
            ExprMut s = vc.exprFromString("x < y");
            ExprMut t = vc.exprFromString("a < b");
            System.out.println("s=" + s + "\nt=" + t);
            ArrayList<ExprMut> oldExprs = new ArrayList<ExprMut>();
            ArrayList<ExprMut> newExprs = new ArrayList<ExprMut>();
            oldExprs.add(x);
            oldExprs.add(y);
            newExprs.add(a);
            newExprs.add(b);
            Expr u = s.subst(oldExprs, newExprs);
            System.out.println("u=" + u);
            Test.DebugAssert(t.equals(u), "Expected t==u");
        }
        catch (Throwable e) {
            System.out.println("*** Exception caught in test23(): ");
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
        }
        return true;
    }

    public static ExprMut bvadder(ValidityChecker vc, Expr a, Expr b, Expr c) throws Cvc3Exception {
        return vc.newBVXorExpr(a, vc.newBVXorExpr(b, c));
    }

    public static ExprMut bvcarry(ValidityChecker vc, Expr a, Expr b, Expr c) throws Cvc3Exception {
        return vc.newBVOrExpr(vc.newBVAndExpr(a, b), vc.newBVOrExpr(vc.newBVAndExpr(b, c), vc.newBVAndExpr(a, c)));
    }

    public static List bvadd(ValidityChecker vc, List a, List b) throws Cvc3Exception {
        int N = a.size();
        ExprMut c = vc.newBVConstExpr(new Rational(0, vc.embeddedManager()), 1);
        ArrayList<ExprMut> sum = new ArrayList<ExprMut>();
        for (int i = 0; i < N; ++i) {
            sum.add(Test.bvadder(vc, (Expr)a.get(i), (Expr)b.get(i), c));
            c = Test.bvcarry(vc, (Expr)a.get(i), (Expr)b.get(i), c);
        }
        return sum;
    }

    public static ExprMut bvvectorEq(ValidityChecker vc, List a, List b) throws Cvc3Exception {
        int N = a.size();
        ExprMut result = vc.newBVConstExpr("1");
        for (int i = 0; i < N; ++i) {
            result = vc.newBVAndExpr(result, vc.newBVXnorExpr((Expr)a.get(i), (Expr)b.get(i)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean bvtest9(int N) throws Cvc3Exception {
        ValidityChecker vc = null;
        try {
            vc = ValidityChecker.create();
            ExprMut a = vc.varExpr("a", vc.bitvecType(N));
            ExprMut b = vc.varExpr("b", vc.bitvecType(N));
            ArrayList<ExprMut> kids = new ArrayList<ExprMut>();
            kids.add(a);
            kids.add(b);
            ExprMut sum1 = vc.newBVPlusExpr(N, kids);
            ArrayList<ExprMut> avec = new ArrayList<ExprMut>();
            ArrayList<ExprMut> bvec = new ArrayList<ExprMut>();
            ArrayList<ExprMut> sum1vec = new ArrayList<ExprMut>();
            for (int i = 0; i < N; ++i) {
                avec.add(vc.newBVExtractExpr(a, i, i));
                bvec.add(vc.newBVExtractExpr(b, i, i));
                sum1vec.add(vc.newBVExtractExpr(sum1, i, i));
            }
            List sum2 = Test.bvadd(vc, avec, bvec);
            ExprMut q = Test.bvvectorEq(vc, sum1vec, sum2);
            Test.check(vc, vc.eqExpr(q, vc.newBVConstExpr("1")));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in bvtest9(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test10() throws Cvc3Exception {
        ValidityChecker vc = null;
        try {
            vc = ValidityChecker.create();
            ExprMut x = vc.varExpr("x", vc.realType());
            ExprMut y = vc.varExpr("y", vc.realType());
            TypeMut real = vc.realType();
            ArrayList<TypeMut> RxR = new ArrayList<TypeMut>();
            RxR.add(real);
            RxR.add(real);
            TypeMut realxreal2real = vc.funType(RxR, (Type)real);
            OpMut g = vc.createOp("g", realxreal2real);
            ExprMut gxy = vc.funExpr(g, x, y);
            ExprMut gyx = vc.funExpr(g, y, x);
            ExprMut ia = vc.eqExpr(x, y);
            ExprMut ib = vc.eqExpr(gxy, gyx);
            ExprMut e = vc.impliesExpr(vc.eqExpr(x, y), vc.eqExpr(gxy, gyx));
            Test.check(vc, e, false);
            OpMut h = vc.createOp("h", realxreal2real);
            ExprMut hxy = vc.funExpr(h, x, y);
            ExprMut hyx = vc.funExpr(h, y, x);
            e = vc.impliesExpr(vc.eqExpr(x, y), vc.eqExpr(hxy, hyx));
            Test.check(vc, e, false);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test10(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
        }
    }

    public static int printImpliedLiterals(ValidityChecker vc) throws Cvc3Exception {
        int count = 0;
        System.out.println("Implied Literals:");
        ExprMut impLit = vc.getImpliedLiteral();
        while (!impLit.isNull()) {
            ++count;
            System.out.println(impLit);
            impLit = vc.getImpliedLiteral();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test11() throws Cvc3Exception {
        ValidityChecker vc = null;
        try {
            vc = ValidityChecker.create();
            ExprMut x = vc.varExpr("x", vc.realType());
            ExprMut y = vc.varExpr("y", vc.realType());
            ExprMut z = vc.varExpr("z", vc.realType());
            TypeMut real = vc.realType();
            TypeMut real2real = vc.funType(real, (Type)real);
            TypeMut real2bool = vc.funType(real, (Type)vc.boolType());
            OpMut f = vc.createOp("f", real2real);
            OpMut p = vc.createOp("p", real2bool);
            ExprMut fx = vc.funExpr((Op)f, x);
            ExprMut fy = vc.funExpr((Op)f, y);
            ExprMut px = vc.funExpr((Op)p, x);
            ExprMut py = vc.funExpr((Op)p, y);
            ExprMut xeqy = vc.eqExpr(x, y);
            ExprMut yeqx = vc.eqExpr(y, x);
            ExprMut xeqz = vc.eqExpr(x, z);
            ExprMut zeqx = vc.eqExpr(z, x);
            ExprMut yeqz = vc.eqExpr(y, z);
            ExprMut zeqy = vc.eqExpr(z, y);
            vc.registerAtom(vc.eqExpr(x, vc.ratExpr(0, 1)));
            vc.registerAtom(xeqy);
            vc.registerAtom(yeqx);
            vc.registerAtom(xeqz);
            vc.registerAtom(zeqx);
            vc.registerAtom(yeqz);
            vc.registerAtom(zeqy);
            vc.registerAtom(px);
            vc.registerAtom(py);
            vc.registerAtom(vc.eqExpr(fx, fy));
            System.out.println("Push");
            vc.push();
            System.out.println("Assert x = y");
            vc.assertFormula(xeqy);
            int c = Test.printImpliedLiterals(vc);
            Test.DebugAssert(c == 3, "Implied literal error 0");
            System.out.println("Push");
            vc.push();
            System.out.println("Assert x /= z");
            vc.assertFormula(vc.notExpr(xeqz));
            c = Test.printImpliedLiterals(vc);
            Test.DebugAssert(c == 4, "Implied literal error 1");
            System.out.println("Pop");
            vc.pop();
            System.out.println("Push");
            vc.push();
            System.out.println("Assert y /= z");
            vc.assertFormula(vc.notExpr(yeqz));
            c = Test.printImpliedLiterals(vc);
            Test.DebugAssert(c == 4, "Implied literal error 2");
            System.out.println("Pop");
            vc.pop();
            System.out.println("Push");
            vc.push();
            System.out.println("Assert p(x)");
            vc.assertFormula(px);
            c = Test.printImpliedLiterals(vc);
            Test.DebugAssert(c == 2, "Implied literal error 3");
            System.out.println("Pop");
            vc.pop();
            System.out.println("Push");
            vc.push();
            System.out.println("Assert p(y)");
            vc.assertFormula(py);
            c = Test.printImpliedLiterals(vc);
            Test.DebugAssert(c == 2, "Implied literal error 4");
            System.out.println("Pop");
            vc.pop();
            System.out.println("Pop");
            vc.pop();
            System.out.println("Push");
            vc.push();
            System.out.println("Assert y = x");
            vc.assertFormula(yeqx);
            c = Test.printImpliedLiterals(vc);
            Test.DebugAssert(c == 3, "Implied literal error 5");
            System.out.println("Pop");
            vc.pop();
            System.out.println("Push");
            vc.push();
            System.out.println("Assert p(x)");
            vc.assertFormula(px);
            c = Test.printImpliedLiterals(vc);
            Test.DebugAssert(c == 1, "Implied literal error 6");
            System.out.println("Assert x = y");
            vc.assertFormula(xeqy);
            c = Test.printImpliedLiterals(vc);
            Test.DebugAssert(c == 4, "Implied literal error 7");
            System.out.println("Pop");
            vc.pop();
            System.out.println("Push");
            vc.push();
            System.out.println("Assert NOT p(x)");
            vc.assertFormula(vc.notExpr(px));
            c = Test.printImpliedLiterals(vc);
            Test.DebugAssert(c == 1, "Implied literal error 8");
            System.out.println("Assert x = y");
            vc.assertFormula(xeqy);
            c = Test.printImpliedLiterals(vc);
            Test.DebugAssert(c == 4, "Implied literal error 9");
            System.out.println("Pop");
            vc.pop();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test11(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test12() throws Cvc3Exception {
        ValidityChecker vc = null;
        try {
            vc = ValidityChecker.create();
            TypeMut realType = vc.realType();
            TypeMut intType = vc.intType();
            TypeMut boolType = vc.boolType();
            vc.push();
            int initial_layer = vc.stackLevel();
            int initial_scope = vc.scopeLevel();
            ExprMut exprObj_trueID = vc.trueExpr();
            ExprMut exprObj_falseID = vc.notExpr(vc.trueExpr());
            vc.popTo(initial_layer);
            Test.DebugAssert(vc.scopeLevel() == initial_scope, "Expected no change");
            Test.DebugAssert(vc.stackLevel() == initial_layer, "Expected no change");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test12(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test13() throws Cvc3Exception {
        ValidityChecker vc = null;
        FlagsMut flags = null;
        try {
            flags = ValidityChecker.createFlags(null);
            flags.setFlag("dagify-exprs", false);
            flags.setFlag("dump-log", ".test13.cvc");
            vc = ValidityChecker.create(flags);
            ExprMut rat_one = vc.ratExpr(1);
            ExprMut rat_two = vc.ratExpr(2);
            ExprMut rat_minus_one = vc.ratExpr(-1);
            QueryResult query_result = vc.query(vc.eqExpr(rat_two, rat_one));
            System.out.println("2=1 " + query_result);
            query_result = vc.query(vc.eqExpr(rat_two, rat_minus_one));
            System.out.println("2=-1 " + query_result);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test13(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
            if (flags != null) {
                flags.delete();
            }
        }
    }

    public static Expr func1(ValidityChecker vc) throws Cvc3Exception {
        ExprMut tmp = vc.varExpr("tmp", vc.boolType());
        return vc.trueExpr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test14() throws Cvc3Exception {
        ValidityChecker vc = null;
        try {
            vc = ValidityChecker.create();
            Expr test1 = Test.func1(vc);
            Expr test2 = Test.func1(vc);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test13(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test15() throws Cvc3Exception {
        ValidityChecker vc = null;
        FlagsMut flags = null;
        try {
            int i;
            flags = ValidityChecker.createFlags(null);
            flags.setFlag("dagify-exprs", false);
            vc = ValidityChecker.create(flags);
            TypeMut index_type = vc.subrangeType(vc.ratExpr(0), vc.ratExpr(3));
            TypeMut data_type = vc.subrangeType(vc.ratExpr(0), vc.ratExpr(3));
            TypeMut array_type = vc.arrayType(index_type, data_type);
            ExprMut arr = vc.varExpr("array", array_type);
            arr = vc.writeExpr(arr, vc.ratExpr(0), vc.ratExpr(1));
            arr = vc.writeExpr(arr, vc.ratExpr(1), vc.ratExpr(1));
            arr = vc.writeExpr(arr, vc.ratExpr(2), vc.ratExpr(0));
            arr = vc.writeExpr(arr, vc.ratExpr(3), vc.ratExpr(0));
            ExprMut id = vc.boundVarExpr("id", "0", vc.subrangeType(vc.ratExpr(0), vc.ratExpr(2)));
            ArrayList<ExprMut> vars = new ArrayList<ExprMut>();
            vars.add(id);
            ExprMut for_body = vc.leExpr(vc.readExpr(arr, id), vc.readExpr(arr, vc.plusExpr(id, vc.ratExpr(1))));
            ExprMut forall_expr = vc.forallExpr(vars, for_body);
            vc.push();
            Test.check(vc, forall_expr);
            System.out.println("Scope level: " + vc.scopeLevel());
            System.out.println("Counter-example:");
            List assertions = vc.getCounterExample();
            for (int i2 = 0; i2 < assertions.size(); ++i2) {
                System.out.println(assertions.get(i2));
            }
            System.out.println("End of counter-example");
            System.out.println("");
            vc.pop();
            ExprMut e1 = vc.leExpr(vc.readExpr(arr, vc.ratExpr(0)), vc.readExpr(arr, vc.ratExpr(1)));
            ExprMut e2 = vc.leExpr(vc.readExpr(arr, vc.ratExpr(1)), vc.readExpr(arr, vc.ratExpr(2)));
            ExprMut e3 = vc.leExpr(vc.readExpr(arr, vc.ratExpr(2)), vc.readExpr(arr, vc.ratExpr(3)));
            ExprMut manual_expr = vc.andExpr(e1, vc.andExpr(e2, e3));
            ExprMut id_ex = vc.varExpr("id_ex", vc.subrangeType(vc.ratExpr(0), vc.ratExpr(2)));
            ArrayList<ExprMut> vars_ex = new ArrayList<ExprMut>();
            vars_ex.add(id_ex);
            ExprMut ex_body = vc.gtExpr(vc.readExpr(arr, id_ex), vc.readExpr(arr, vc.plusExpr(id_ex, vc.ratExpr(1))));
            ExprMut ex_expr = vc.existsExpr(vars_ex, ex_body);
            System.out.println("Checking forallExpr <==> manual expansion ...");
            if (vc.query(vc.iffExpr(forall_expr, manual_expr)) == QueryResult.VALID) {
                System.out.println("   -- yes.");
            } else {
                System.out.println("   -- no, with counter examples as ");
                List assert1 = vc.getCounterExample();
                for (i = 0; i < assert1.size(); ++i) {
                    System.out.println(assert1.get(i));
                }
            }
            System.out.println();
            System.out.println();
            System.out.println("Checking !forallExpr <==> existsExpr ...");
            if (vc.query(vc.iffExpr(vc.notExpr(forall_expr), ex_expr)) == QueryResult.VALID) {
                System.out.println("   -- yes.");
            } else if (vc.incomplete()) {
                System.out.println("   -- incomplete:");
                List reasons = vc.incompleteReasons();
                for (i = 0; i < reasons.size(); ++i) {
                    System.out.println(reasons.get(i));
                }
            } else {
                System.out.println("   -- no, with counter examples as ");
                List assert2 = vc.getCounterExample();
                for (i = 0; i < assert2.size(); ++i) {
                    System.out.println(assert2.get(i));
                }
            }
            System.out.println();
            System.out.println("End of testcases.");
            System.out.println();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test15(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
            if (flags != null) {
                flags.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test16() throws Cvc3Exception {
        ValidityChecker vc = null;
        try {
            vc = ValidityChecker.create();
            TypeMut zto100 = vc.subrangeType(vc.ratExpr(0), vc.ratExpr(100));
            ExprMut mem = vc.varExpr("mem", vc.arrayType(zto100, vc.intType()));
            ExprMut a = vc.varExpr("a", zto100);
            ExprMut b = vc.varExpr("b", zto100);
            ExprMut lhs = vc.readExpr(vc.writeExpr(mem, a, vc.ratExpr(30)), b);
            ExprMut rhs = vc.readExpr(vc.writeExpr(mem, b, vc.ratExpr(40)), a);
            ExprMut q = vc.impliesExpr(vc.notExpr(vc.eqExpr(a, b)), vc.eqExpr(lhs, rhs));
            Test.check(vc, q);
            System.out.println("Scope level: " + vc.scopeLevel());
            System.out.println("Counter-example:");
            List assertions = vc.getCounterExample();
            Test.DebugAssert(assertions.size() > 0, "Expected non-empty counter-example");
            for (int i = 0; i < assertions.size(); ++i) {
                System.out.println(assertions.get(i));
            }
            System.out.println("End of counter-example");
            System.out.println();
            HashMap m = vc.getConcreteModel();
            if (m.isEmpty()) {
                System.out.println(" Did not find concrete model for any vars");
            } else {
                System.out.println("%Satisfiable  Variable Assignment: %");
                Iterator it = m.entrySet().iterator();
                while (it.hasNext()) {
                    Expr eq;
                    Map.Entry next = it.next();
                    Expr key = (Expr)next.getKey();
                    Expr value = (Expr)next.getValue();
                    if (key.getType().isBoolean()) {
                        Test.DebugAssert(value.isBooleanConst(), "Bad variable assignement: e = " + key + "\n\n val = " + value);
                        eq = value.isTrue() ? key : vc.notExpr(key);
                    } else {
                        eq = vc.eqExpr(key, value);
                    }
                    System.out.println(eq);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test16(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test17() throws Cvc3Exception {
        ValidityChecker vc = null;
        try {
            vc = ValidityChecker.create();
            try {
                ArrayList<String> selectors = new ArrayList<String>();
                ArrayList<Expr> types = new ArrayList<Expr>();
                selectors.add("car");
                types.add(vc.intType().getExpr());
                selectors.add("cdr");
                types.add(vc.stringExpr("list"));
                TypeMut badList = vc.dataType("list", "cons", selectors, types);
                Test.DebugAssert(false, "Typechecking exception expected");
            }
            catch (TypecheckException e) {
                // empty catch block
            }
            vc.delete();
            vc = ValidityChecker.create();
            ArrayList<String> constructors = new ArrayList<String>();
            ArrayList selectors = new ArrayList();
            ArrayList<String> selectors0 = new ArrayList<String>();
            ArrayList selectors1 = new ArrayList();
            selectors.add(selectors0);
            selectors.add(selectors1);
            ArrayList types = new ArrayList();
            ArrayList<Expr> types0 = new ArrayList<Expr>();
            ArrayList types1 = new ArrayList();
            types.add(types0);
            types.add(types1);
            constructors.add("cons");
            selectors0.add("car");
            types0.add(vc.intType().getExpr());
            selectors0.add("cdr");
            types0.add(vc.stringExpr("list"));
            constructors.add("null");
            TypeMut list = vc.dataType("list", constructors, selectors, types);
            ExprMut x = vc.varExpr("x", vc.intType());
            ExprMut y = vc.varExpr("y", list);
            ArrayList<ExprMut> args = new ArrayList<ExprMut>();
            args.add(x);
            args.add(y);
            ExprMut cons = vc.datatypeConsExpr("cons", args);
            ExprMut sel = vc.datatypeSelExpr("car", cons);
            boolean b = Test.check(vc, vc.eqExpr(sel, x));
            Test.DebugAssert(b, "Should be valid");
            vc.delete();
            vc = ValidityChecker.create();
            try {
                ArrayList<String> names = new ArrayList<String>();
                ArrayList constructors2 = new ArrayList();
                ArrayList<String> constructors0 = new ArrayList<String>();
                ArrayList<String> constructors1 = new ArrayList<String>();
                constructors2.add(constructors0);
                constructors2.add(constructors1);
                ArrayList selectors2 = new ArrayList();
                ArrayList selectors02 = new ArrayList();
                ArrayList selectors12 = new ArrayList();
                ArrayList<String> selectors00 = new ArrayList<String>();
                ArrayList<String> selectors10 = new ArrayList<String>();
                selectors2.add(selectors02);
                selectors02.add(selectors00);
                selectors2.add(selectors12);
                selectors12.add(selectors10);
                ArrayList types2 = new ArrayList();
                ArrayList types02 = new ArrayList();
                ArrayList types12 = new ArrayList();
                ArrayList<Expr> types00 = new ArrayList<Expr>();
                ArrayList<Expr> types10 = new ArrayList<Expr>();
                types2.add(types02);
                types02.add(types00);
                types2.add(types12);
                types12.add(types10);
                names.add("list1");
                constructors0.add("cons1");
                selectors00.add("car1");
                types00.add(vc.intType().getExpr());
                selectors00.add("cdr1");
                types00.add(vc.stringExpr("list2"));
                names.add("list2");
                constructors1.add("cons2");
                selectors10.add("car2");
                types10.add(vc.intType().getExpr());
                selectors10.add("cdr2");
                types10.add(vc.stringExpr("list1"));
                constructors1.add("null");
                List returnTypes = vc.dataType(names, constructors2, selectors2, types2);
                Type list1 = (Type)returnTypes.get(0);
                Type list2 = (Type)returnTypes.get(1);
                ExprMut x2 = vc.varExpr("x", vc.intType());
                ExprMut y2 = vc.varExpr("y", list2);
                ExprMut z = vc.varExpr("z", list1);
                ArrayList<ExprMut> args2 = new ArrayList<ExprMut>();
                args2.add(x2);
                args2.add(y2);
                ExprMut cons1 = vc.datatypeConsExpr("cons1", args2);
                ExprMut isnull = vc.datatypeTestExpr("null", y2);
                ExprMut hyp = vc.andExpr(vc.eqExpr(z, cons1), isnull);
                ExprMut nullE = vc.datatypeConsExpr("null", new ArrayList());
                args2 = new ArrayList();
                args2.add(x2);
                args2.add(nullE);
                ExprMut cons1_2 = vc.datatypeConsExpr("cons1", args2);
                boolean b2 = Test.check(vc, vc.impliesExpr(hyp, vc.eqExpr(z, cons1_2)));
                Test.DebugAssert(b2, "Should be valid");
            }
            catch (TypecheckException e) {
                // empty catch block
            }
            vc.delete();
            vc = ValidityChecker.create();
            constructors = new ArrayList();
            selectors = new ArrayList();
            selectors.add(new ArrayList());
            selectors.add(new ArrayList());
            ArrayList types3 = new ArrayList();
            types3.add(new ArrayList());
            types3.add(new ArrayList());
            constructors.add("A");
            constructors.add("B");
            TypeMut two = vc.dataType("two", constructors, selectors, types3);
            ExprMut x3 = vc.varExpr("x", two);
            ExprMut y3 = vc.varExpr("y", two);
            ExprMut z = vc.varExpr("z", two);
            ArrayList<ExprMut> args3 = new ArrayList<ExprMut>();
            args3.add(vc.notExpr(vc.eqExpr(x3, y3)));
            args3.add(vc.notExpr(vc.eqExpr(y3, z)));
            args3.add(vc.notExpr(vc.eqExpr(x3, z)));
            boolean b3 = Test.check(vc, vc.notExpr(vc.andExpr(args3)));
            Test.DebugAssert(b3, "Should be valid");
            boolean constructors2 = true;
            return constructors2;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test17(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test18() throws Cvc3Exception {
        ValidityChecker vc = null;
        FlagsMut flags = null;
        try {
            flags = ValidityChecker.createFlags(null);
            flags.setFlag("tcc", true);
            vc = ValidityChecker.create(flags);
            ArrayList<String> names = new ArrayList<String>();
            ArrayList constructors = new ArrayList();
            ArrayList<String> constructors0 = new ArrayList<String>();
            ArrayList<String> constructors1 = new ArrayList<String>();
            ArrayList<String> constructors2 = new ArrayList<String>();
            constructors.add(constructors0);
            constructors.add(constructors1);
            constructors.add(constructors2);
            ArrayList selectors = new ArrayList();
            ArrayList selectors0 = new ArrayList();
            ArrayList selectors1 = new ArrayList();
            ArrayList selectors2 = new ArrayList();
            ArrayList selectors00 = new ArrayList();
            ArrayList<String> selectors01 = new ArrayList<String>();
            ArrayList<String> selectors10 = new ArrayList<String>();
            ArrayList selectors11 = new ArrayList();
            ArrayList selectors20 = new ArrayList();
            ArrayList<String> selectors21 = new ArrayList<String>();
            selectors.add(selectors0);
            selectors0.add(selectors00);
            selectors0.add(selectors01);
            selectors.add(selectors1);
            selectors1.add(selectors10);
            selectors1.add(selectors11);
            selectors.add(selectors2);
            selectors2.add(selectors20);
            selectors2.add(selectors21);
            ArrayList types = new ArrayList();
            ArrayList types0 = new ArrayList();
            ArrayList types1 = new ArrayList();
            ArrayList types2 = new ArrayList();
            ArrayList types00 = new ArrayList();
            ArrayList<ExprMut> types01 = new ArrayList<ExprMut>();
            ArrayList<ExprMut> types10 = new ArrayList<ExprMut>();
            ArrayList types11 = new ArrayList();
            ArrayList types20 = new ArrayList();
            ArrayList<ExprMut> types21 = new ArrayList<ExprMut>();
            types.add(types0);
            types0.add(types00);
            types0.add(types01);
            types.add(types1);
            types1.add(types10);
            types1.add(types11);
            types.add(types2);
            types2.add(types20);
            types2.add(types21);
            names.add("nat");
            constructors0.add("zero");
            constructors0.add("succ");
            selectors01.add("pred");
            types01.add(vc.stringExpr("nat"));
            names.add("list");
            constructors1.add("cons");
            selectors10.add("car");
            types10.add(vc.stringExpr("tree"));
            selectors10.add("cdr");
            types10.add(vc.stringExpr("list"));
            constructors1.add("null");
            names.add("tree");
            constructors2.add("leaf");
            constructors2.add("node");
            selectors21.add("data");
            types21.add(vc.stringExpr("nat"));
            selectors21.add("children");
            types21.add(vc.stringExpr("list"));
            List returnTypes = vc.dataType(names, constructors, selectors, types);
            Type nat = (Type)returnTypes.get(0);
            Type listType = (Type)returnTypes.get(1);
            Type tree = (Type)returnTypes.get(2);
            ExprMut x = vc.varExpr("x", nat);
            ArrayList<ExprMut> args = new ArrayList<ExprMut>();
            ExprMut zero = vc.datatypeConsExpr("zero", args);
            ExprMut nullE = vc.datatypeConsExpr("null", args);
            ExprMut leaf = vc.datatypeConsExpr("leaf", args);
            vc.push();
            try {
                Test.check(vc, vc.notExpr(vc.eqExpr(zero, nullE)));
                Test.DebugAssert(false, "Should have caught tcc exception");
            }
            catch (TypecheckException e) {
                // empty catch block
            }
            vc.pop();
            args.add(vc.datatypeSelExpr("pred", x));
            ExprMut spx = vc.datatypeConsExpr("succ", args);
            ExprMut spxeqx = vc.eqExpr(spx, x);
            vc.push();
            try {
                Test.check(vc, spxeqx);
                Test.DebugAssert(false, "Should have caught tcc exception");
            }
            catch (TypecheckException e) {
                // empty catch block
            }
            vc.pop();
            boolean b = Test.check(vc, vc.impliesExpr(vc.datatypeTestExpr("succ", x), spxeqx));
            Test.DebugAssert(b, "Should be valid");
            b = Test.check(vc, vc.orExpr(vc.datatypeTestExpr("zero", x), vc.datatypeTestExpr("succ", x)));
            Test.DebugAssert(b, "Should be valid");
            ExprMut y = vc.varExpr("y", nat);
            ExprMut xeqy = vc.eqExpr(x, y);
            args.clear();
            args.add(x);
            ExprMut sx = vc.datatypeConsExpr("succ", args);
            args.clear();
            args.add(y);
            ExprMut sy = vc.datatypeConsExpr("succ", args);
            ExprMut sxeqsy = vc.eqExpr(sx, sy);
            b = Test.check(vc, vc.impliesExpr(xeqy, sxeqsy));
            Test.DebugAssert(b, "Should be valid");
            b = Test.check(vc, vc.notExpr(vc.eqExpr(sx, zero)));
            Test.DebugAssert(b, "Should be valid");
            b = Test.check(vc, vc.impliesExpr(sxeqsy, xeqy));
            Test.DebugAssert(b, "Should be valid");
            b = Test.check(vc, vc.notExpr(vc.eqExpr(sx, x)));
            Test.DebugAssert(b, "Should be valid");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test18(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
            if (flags != null) {
                flags.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean test19() throws Cvc3Exception {
        ValidityChecker vc = null;
        FlagsMut flags = null;
        try {
            flags = ValidityChecker.createFlags(null);
            flags.setFlag("dagify-exprs", false);
            vc = ValidityChecker.create(flags);
            TypeMut RealType = vc.realType();
            TypeMut IntType = vc.intType();
            TypeMut BoolType = vc.boolType();
            TypeMut PtrType = RealType;
            TypeMut HeapType = vc.arrayType(PtrType, RealType);
            ExprMut Ad = vc.boundVarExpr("CVCi", "CVCi", RealType);
            ExprMut Hs = vc.varExpr("Hs", HeapType);
            ExprMut Ht = vc.varExpr("Ht", HeapType);
            ExprMut t6 = vc.varExpr("t6", RealType);
            ArrayList<ExprMut> Vars = new ArrayList<ExprMut>();
            Vars.add(Ad);
            ExprMut Body = vc.eqExpr(vc.readExpr(Hs, Ad), vc.readExpr(Ht, Ad));
            ExprMut A = vc.forallExpr(Vars, Body);
            ExprMut Q = vc.eqExpr(vc.readExpr(Hs, t6), vc.readExpr(Ht, t6));
            vc.push();
            vc.assertFormula(A);
            System.out.println("Checking formula " + Q);
            System.out.println(" in context " + A);
            QueryResult Succ = vc.query(Q);
            Test.DebugAssert(Succ == QueryResult.VALID, "Expected valid formula");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test19(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
            if (flags != null) {
                flags.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testNonlinearBV() throws Cvc3Exception {
        ValidityChecker vc = null;
        FlagsMut flags = null;
        try {
            flags = ValidityChecker.createFlags(null);
            flags.setFlag("dagify-exprs", false);
            vc = ValidityChecker.create(flags);
            int bvLength = 8;
            Rational zero = new Rational(0, vc.embeddedManager());
            ExprMut x = vc.varExpr("x", vc.bitvecType(bvLength));
            ExprMut y = vc.varExpr("y", vc.bitvecType(bvLength));
            ExprMut bv0 = vc.newBVConstExpr(zero, bvLength);
            vc.push();
            System.out.println("Checking BVUDIV:");
            ExprMut udiv = vc.newBVUDivExpr(x, y);
            ExprMut umult = vc.newBVMultExpr(bvLength, udiv, y);
            ExprMut test = vc.eqExpr(bv0, y);
            boolean result = Test.check(vc, vc.impliesExpr(vc.notExpr(test), vc.newBVLEExpr(umult, x)), true);
            Test.DebugAssert(result, "Expected valid formula");
            vc.pop();
            vc.push();
            System.out.println("Checking BVUREM:");
            ExprMut urem = vc.newBVURemExpr(x, y);
            result = Test.check(vc, vc.impliesExpr(vc.notExpr(test), vc.newBVLTExpr(urem, y)), true);
            Test.DebugAssert(result, "Expected valid formula");
            vc.pop();
            vc.push();
            System.out.println("Checking BVSDIV:");
            ExprMut sdiv = vc.newBVSDivExpr(x, y);
            ExprMut smult = vc.newBVMultExpr(bvLength, sdiv, y);
            ExprMut signed_test = vc.newBVSLEExpr(bv0, x);
            signed_test = vc.andExpr(signed_test, vc.newBVSLTExpr(bv0, y));
            result = Test.check(vc, vc.impliesExpr(signed_test, vc.newBVSLEExpr(smult, x)), true);
            Test.DebugAssert(result, "Expected valid formula");
            vc.pop();
            vc.push();
            System.out.println("Checking BVSREM:");
            ExprMut srem = vc.newBVSRemExpr(x, y);
            result = Test.check(vc, vc.impliesExpr(signed_test, vc.newBVLTExpr(srem, y)), true);
            Test.DebugAssert(result, "Expected valid formula");
            vc.pop();
            vc.push();
            System.out.println("Checking BVSMOD:");
            ExprMut smod = vc.newBVSModExpr(x, y);
            result = Test.check(vc, vc.impliesExpr(signed_test, vc.newBVLTExpr(smod, y)), true);
            Test.DebugAssert(result, "Expected valid formula");
            vc.pop();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test19(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
            if (flags != null) {
                flags.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testDistinct() throws Cvc3Exception {
        ValidityChecker vc = null;
        FlagsMut flags = null;
        try {
            flags = ValidityChecker.createFlags(null);
            vc = ValidityChecker.create(flags);
            int bvLength = 2;
            int elements_count = bvLength * bvLength + 1;
            ArrayList<ExprMut> elements = new ArrayList<ExprMut>();
            for (int i = 0; i < elements_count; ++i) {
                elements.add(vc.varExpr("x" + i, vc.bitvecType(bvLength)));
            }
            ExprMut distinct = vc.distinctExpr(elements);
            boolean result = Test.check(vc, vc.notExpr(distinct), true);
            Test.DebugAssert(result, "Expected valid formula");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("*** Exception caught in test19(): \n" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (vc != null) {
                vc.delete();
            }
            if (flags != null) {
                flags.delete();
            }
        }
    }

    static {
        $assertionsDisabled = !Test.class.desiredAssertionStatus();
    }
}

