import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
public class SignRotationMatrix {

	public static List<Sign[]> signMatList = new ArrayList<Sign[]>();
	public static List<double[]> ValueMatList = new ArrayList<double[]>();
	public static HashMap<String,ArrayList<Sign[]>> matrixMap = new HashMap<String,ArrayList<Sign[]>>();
	static int instNum=0;
	static int unInstNum=0;
	static String Vec, VecR, RLM,RRM,RLRRM;
	static final int pre = 1000;
	static String[] u = {"+00","++0","+++"};	
	static String[] Q = {"++++-+++-","++++-++--","++++--++-","++++---+-","++0-+++-+","++++0--+-","+++--++-0",
		"+++++--+0","+++-0++-+","++0-+--++","+000+-0++","+0-0+0+0+","+-0++000+","+000+000+"};
	static int[][] P = new int[24][9];//Permutation Matrices
	static String[][] QP = new String[14][24];
	static String[][] PQ = new String[14][24];
	static String[][] uP = new String[3][24]; // 3*24=
	static boolean[][][][] BQQQP = new boolean[14][14][14][24];
	static boolean[][] BQQtot=new boolean[14][14];
	static int[][] QxQtotNum= new int[14][14];
	static int[][] QxQachivedNum= new int[14][14];
	int ccc=0;
	static int qInx=0, pInx=0,pTransInx=-1;
	static int uInx=0; 
	static int[] vpInx=new int[4];
	static double[][] Qval = new double[14][9];
//	static ArrayList<String>[][] potentialQxQ = new ArrayList<String>[14][14];
//	public static HashMap<String,ArrayList<String>> potentialQxQ = new HashMap<String,ArrayList<String>>();
	
	public static String squarPrint(Sign[] m){
		String output = "";
		for(int i=0; i<m.length; i++){
			output+=m[i];
			output+=" ";
			if(i%3==2) output +='\n';
		}
		return output;
	}
	public static String squarPrint(String m){
		String output = "";
		for(int i=0; i<m.length(); i+=3){
			output+="|"+m.charAt(i)+" "+m.charAt(i+1)+" "+m.charAt(i+2)+"|\n";
			//			output+=" ";
			//			if(i%3==2) output +='\n';
		}
		return output;
	}
	public static String squarPrint(Sign[] sM, double[] dM ){

		String output="";
		output =        sM[0]+" "+sM[1]+" "+sM[2]+"      "+dM[0]+" "+dM[1]+" "+dM[2]+'\n'+
				sM[3]+" "+sM[4]+" "+sM[5]+"      "+dM[3]+" "+dM[4]+" "+dM[5]+'\n'+
				sM[6]+" "+sM[7]+" "+sM[8]+"      "+dM[6]+" "+dM[7]+" "+dM[8]+'\n';
		return output;
	}
	public static String squarPrintMxM(String sM, String dM ){	
		String output="";
		output ="|"+sM.charAt(0)+" "+sM.charAt(1)+" "+sM.charAt(2)+"|   |"+dM.charAt(0)+" "+dM.charAt(1)+" "+dM.charAt(2)+"|\n"+
				"|"+sM.charAt(3)+" "+sM.charAt(4)+" "+sM.charAt(5)+"| \u00D7 |"+dM.charAt(3)+" "+dM.charAt(4)+" "+dM.charAt(5)+"|\n"+
				"|"+sM.charAt(6)+" "+sM.charAt(7)+" "+sM.charAt(8)+"|   |"+dM.charAt(6)+" "+dM.charAt(7)+" "+dM.charAt(8)+"|\n";
		return output;
	}
	public static String squarPrintMxMP(String sM, String dM, String pM ){	
		String output="";
		output ="|"+sM.charAt(0)+" "+sM.charAt(1)+" "+sM.charAt(2)+"|   |"+dM.charAt(0)+" "+dM.charAt(1)+" "+dM.charAt(2)+"|   |"+pM.charAt(0)+" "+pM.charAt(1)+" "+pM.charAt(2)+"|\n"+
				"|"+sM.charAt(3)+" "+sM.charAt(4)+" "+sM.charAt(5)+"| \u00D7 |"+dM.charAt(3)+" "+dM.charAt(4)+" "+dM.charAt(5)+"| = |"+pM.charAt(3)+" "+pM.charAt(4)+" "+pM.charAt(5)+"|\n"+
				"|"+sM.charAt(6)+" "+sM.charAt(7)+" "+sM.charAt(8)+"|   |"+dM.charAt(6)+" "+dM.charAt(7)+" "+dM.charAt(8)+"|   |"+pM.charAt(6)+" "+pM.charAt(7)+" "+pM.charAt(8)+"|\n";
		return output;
	}

	public static String squarPrintfactorizingRxS(String sM, String dM, int[] pM ){	
		String output="";
		output ="|"+sM.charAt(0)+" "+sM.charAt(1)+" "+sM.charAt(2)+"|     |"+dM.charAt(0)+" "+dM.charAt(1)+" "+dM.charAt(2)+"|     |"+pM[0]+" "+pM[1]+" "+pM[2]+"|\n"+
				"|"+sM.charAt(3)+" "+sM.charAt(4)+" "+sM.charAt(5)+"| \u00D7   |"+dM.charAt(3)+" "+dM.charAt(4)+" "+dM.charAt(5)+"| \u00D7   |"+pM[3]+" "+pM[4]+" "+pM[5]+"|\n"+
				"|"+sM.charAt(6)+" "+sM.charAt(7)+" "+sM.charAt(8)+"|     |"+dM.charAt(6)+" "+dM.charAt(7)+" "+dM.charAt(8)+"|     |"+pM[6]+" "+pM[7]+" "+pM[8]+"|\n";
		return output;
	}
	public static String squarPrintfactorizingvxR(String sM, String dM, int[] pM ){	
		String output="";
		output ="          |"+dM.charAt(0)+" "+dM.charAt(1)+" "+dM.charAt(2)+"|   |"+pM[0]+" "+pM[1]+" "+pM[2]+"|\n"+
				"|"+sM.charAt(0)+" "+sM.charAt(1)+" "+sM.charAt(2)+"| \u00D7 |"+dM.charAt(3)+" "+dM.charAt(4)+" "+dM.charAt(5)+"| \u00D7 |"+pM[3]+" "+pM[4]+" "+pM[5]+"|\n"+
				"          |"+dM.charAt(6)+" "+dM.charAt(7)+" "+dM.charAt(8)+"|   |"+pM[6]+" "+pM[7]+" "+pM[8]+"|\n";
		return output;
	}

	public static String squarPrintvxM(String sM, String dM ){

		String output="";
		output =        "          |"+dM.charAt(0)+" "+dM.charAt(1)+" "+dM.charAt(2)+"|\n"+
				"|"+sM.charAt(0)+" "+sM.charAt(1)+" "+sM.charAt(2)+"| \u00D7 |"+dM.charAt(3)+" "+dM.charAt(4)+" "+dM.charAt(5)+"|\n"+
				"          |"+dM.charAt(6)+" "+dM.charAt(7)+" "+dM.charAt(8)+"|\n";
		return output;
	}
	public static String squarPrintvxMP(String sM, String dM, String pM){
		String vec  = "|"+sM.charAt(0)+" "+sM.charAt(1)+" "+sM.charAt(2)+"| \u00D7 ";
		StringBuffer spaces=new StringBuffer();
		for (int i = 0; i < vec.length(); i++)	spaces.append(" ");
		String s = spaces.toString();
		String output= s+"|"+dM.charAt(0)+" "+dM.charAt(1)+" "+dM.charAt(2)+"|\n"+
				vec+"|"+dM.charAt(3)+" "+dM.charAt(4)+" "+dM.charAt(5)+"| = |"+pM.charAt(0)+" "+pM.charAt(1)+" "+pM.charAt(2)+"|\n"+
				s+"|"+dM.charAt(6)+" "+dM.charAt(7)+" "+dM.charAt(8)+"|\n";
		return output;
	}
	public static String squarPrintMxMM(Sign[] us, Sign[] Qs, Sign[] usxQs){

		String output="";
		output =        us[0]+" "+us[1]+" "+us[2]+"        "+Qs[0]+" "+Qs[1]+" "+Qs[2]+"          "+ usxQs[0]+" "+usxQs[1]+" "+usxQs[2]+'\n'+   
				"             "+Qs[3]+" "+Qs[4]+" "+Qs[5]+"          "+'\n'+
				"             "+Qs[6]+" "+Qs[7]+" "+Qs[8]+"          "+'\n';
		return output;
	}
	public static String squarPrint(double[] m){
		String output = "";
		for(int i=0; i<m.length; i++){
			output+= Math.floor(m[i]*pre+.5)/pre;			
			output+=" ";
			if(i%3==2) output +='\n';
		}
		return output;
	}
	public static String squarPrintVRP(double[] vv,  double[] rr, double[] pp){
		String vec = "|"+Math.floor(vv[0]*pre+.5)/pre+" "+Math.floor(vv[1]*pre+.5)/pre+" "+Math.floor(vv[2]*pre+.5)/pre+"| \u00D7 ";
		StringBuffer spaces=new StringBuffer();
		for (int i = 0; i < vec.length(); i++)	spaces.append(" ");
		String s = spaces.toString();
		String frow = s+"|"+Math.floor(rr[0]*pre+.5)/pre+" "+Math.floor(rr[1]*pre+.5)/pre+" "+Math.floor(rr[2]*pre+.5)/pre;
		vec +="|"+Math.floor(rr[3]*pre+.5)/pre+" "+Math.floor(rr[4]*pre+.5)/pre+" "+Math.floor(rr[5]*pre+.5)/pre;
		String lrow = s+"|"+Math.floor(rr[6]*pre+.5)/pre+" "+Math.floor(rr[7]*pre+.5)/pre+" "+Math.floor(rr[8]*pre+.5)/pre;
		int len = Math.max(frow.length(), lrow.length());
		int maxLen = Math.max(len, vec.length());
		while(maxLen > frow.length())frow+=" "; //frow+="|";		
		while(maxLen > vec.length())vec+=" ";// vec+="|";
		while(maxLen > lrow.length())lrow+=" "; //lrow+="|";			
		//		int feln = maxLen-frow.length();
		//		int leln = maxLen-lrow.length();
		String output =frow+"|\n"+vec+"| = |"+Math.floor(pp[0]*pre+.5)/pre+" "+Math.floor(pp[1]*pre+.5)/pre+" "+Math.floor(pp[2]*pre+.5)/pre+"|\n"+lrow+"|";		
		return output;
	}
	public static String squarPrintRSP(double[] rr,  double[] ss, double[] pp){
		String Fr = "|"+Math.floor(rr[0]*pre+.5)/pre+" "+Math.floor(rr[1]*pre+.5)/pre+" "+Math.floor(rr[2]*pre+.5)/pre;
		String Sr = "|"+Math.floor(rr[3]*pre+.5)/pre+" "+Math.floor(rr[4]*pre+.5)/pre+" "+Math.floor(rr[5]*pre+.5)/pre;
		String Tr = "|"+Math.floor(rr[6]*pre+.5)/pre+" "+Math.floor(rr[7]*pre+.5)/pre+" "+Math.floor(rr[8]*pre+.5)/pre;
		int ml = Math.max(Fr.length(), Sr.length());
		ml = Math.max(ml, Tr.length());
		while(ml > Fr.length()) Fr+=" ";
		Fr+="|   ";
		while(ml > Sr.length())Sr+=" ";
		Sr+="| \u00D7 ";
		while(ml > Tr.length()) Tr+=" ";
		Tr+="|   ";	    
		Fr+="|"+Math.floor(ss[0]*pre+.5)/pre+" "+Math.floor(ss[1]*pre+.5)/pre+" "+Math.floor(ss[2]*pre+.5)/pre;
		Sr+="|"+Math.floor(ss[3]*pre+.5)/pre+" "+Math.floor(ss[4]*pre+.5)/pre+" "+Math.floor(ss[5]*pre+.5)/pre;
		Tr+="|"+Math.floor(ss[6]*pre+.5)/pre+" "+Math.floor(ss[7]*pre+.5)/pre+" "+Math.floor(ss[8]*pre+.5)/pre;
		ml = Math.max(Fr.length(), Sr.length());
		ml = Math.max(ml, Tr.length());
		while(ml > Fr.length()) Fr+=" ";
		Fr+="|   ";
		while(ml > Sr.length())Sr+=" ";
		Sr+="| = ";
		while(ml > Tr.length()) Tr+=" ";
		Tr+="|   ";	 
		Fr+="|"+Math.floor(pp[0]*pre+.5)/pre+" "+Math.floor(pp[1]*pre+.5)/pre+" "+Math.floor(pp[2]*pre+.5)/pre;		
		Sr+="|"+Math.floor(pp[3]*pre+.5)/pre+" "+Math.floor(pp[4]*pre+.5)/pre+" "+Math.floor(pp[5]*pre+.5)/pre;		
		Tr+="|"+Math.floor(pp[6]*pre+.5)/pre+" "+Math.floor(pp[7]*pre+.5)/pre+" "+Math.floor(pp[8]*pre+.5)/pre;		
		ml = Math.max(Fr.length(), Sr.length());
		ml = Math.max(ml, Tr.length());
		while(ml > Fr.length()) Fr+=" ";
		Fr+="|\n";
		while(ml > Sr.length())Sr+=" ";
		Sr+="|\n";
		while(ml > Tr.length()) Tr+=" ";
		Tr+="|\n";	
		return Fr+Sr+Tr;
	}
	public static String squarPrint(int[] m){
		String output = "";
		for(int i=0; i<m.length; i++){
			output+=m[i];
			output+=" ";
			if(i%3==2) output +='\n';
		}
		return output;
	}	
	public static String squarPrint(char[] m){
		String output = "";
		for(int i=0; i<m.length; i++){
			output+=m[i];
			output+=" ";
			if(i%3==2) output +='\n';
		}
		return output;
	}
	public static String stringPrint(Sign[] m){
		String output = "";
		for(int i=0; i<m.length; i++){
			output+=m[i];
		}
		return output;
	}
	public static String stringPrint(char[] m){	
		String output = "";
		for(int i=0; i<m.length; i++)	output+=m[i];
		return output;
	}
	public static String stringPrint(double[] m){
		String output = "";
		for(int i=0; i<m.length; i++){
			output+= Math.floor(m[i]*pre+.5)/pre;			
			output+=" ";
		}
		return output;
	}
	public static double vecLength(double vx, double vy, double vz){ 
		return Math.sqrt(Math.pow(vx, 2)+ Math.pow(vy, 2) + Math.pow(vz, 2));		
	}

	public static char negate(char c){
		if(c=='+') return '-';
		else if(c=='-') return '+';
		else return c;
	}
	public static int zRotate(int xOff, int yOff){
		int zOff=0;
		if(xOff==1){
			if(yOff==2) zOff=3;
			else if(yOff==3)zOff=-2;
			else if(yOff==-2)zOff=-3;
			else if(yOff==-3) zOff=2;
		}else if(xOff==-1){
			if(yOff==2) zOff=-3;
			else if(yOff==3)zOff=2;
			else if(yOff==-2)zOff=3;
			else if(yOff==-3) zOff=-2;
		}else if(xOff==2){
			if(yOff==3) zOff=1;
			else if(yOff==-3)zOff=-1;
			else if(yOff==-1)zOff=3;
			else if(yOff==1) zOff=-3;
		}else if(xOff==-2){
			if(yOff==3) zOff=-1;
			else if(yOff==-3)zOff=1;
			else if(yOff==-1)zOff=-3;
			else if(yOff==1) zOff=3;
		}else if(xOff==3){
			if(yOff==2) zOff=-1;
			else if(yOff==-2)zOff=1;
			else if(yOff==-1)zOff=-2;
			else if(yOff==1) zOff=2;
		}else if(xOff==-3){
			if(yOff==2) zOff=1;
			else if(yOff==-2)zOff=-1;
			else if(yOff==-1)zOff=2;
			else if(yOff==1) zOff=-2;
		}
		return zOff;
	}
	public static int[] transpose(int[] m){
		int[] sm=new int[9];//Transpose of matrix m
		sm[0]=m[0];
		sm[1]=m[3];
		sm[2]=m[6];

		sm[3]=m[1];
		sm[4]=m[4];
		sm[5]=m[7];

		sm[6]=m[2];
		sm[7]=m[5];
		sm[8]=m[8];
		return sm;
	}	
	public static String transpose(String Qs){
		return stringPrint(transpose(QstrToQsign(Qs)));
	}
	public static Sign[] transpose(Sign[] Qs){
		Sign[] TQsign= new Sign[9];//Transpose of Q[j], just for making the cross product of usign and Qsign easier
		for(int j=0; j<3; j++){
			for(int k=0; k<3; k++){
				TQsign[k*3+j] = new Sign(Qs[j*3+k]);				
			}
		}
		return TQsign;
	}

	public static double[] transpose(double[] Qd){
		double[] TQdouble= new double[9];//Transpose of Q[j], just for making the cross product of usign and Qsign easier
		for(int j=0; j<3; j++){
			for(int k=0; k<3; k++){
				TQdouble[k*3+j] = Qd[j*3+k];				
			}
		}
		return TQdouble;
	}

	public static boolean equal(int[] l, int[] r){
		for(int j=0; j<9; j++){
			if(l[j]!=r[j]) return false;
		}
		return true;
	}

	public static void permutationGenerator(){
		int nc=0;
		for(int xo=1; xo<4; xo++){
			for(int xs=-1; xs<2; xs+=2){
				for(int yo=1; yo<4; yo++){
					for(int ys=-1; ys<2; ys+=2){
						if(yo!=xo){
							int z=zRotate(xs*xo,ys*yo);
							P[nc]= new int[9];
							P[nc][xo-1]=xs;
							P[nc][3+yo-1]=ys;
							P[nc][6+Math.abs(z)-1]=z/Math.abs(z);
							for(int uu=0; uu<3; uu++){
								uP[uu][nc] = uxP(u[uu],xs*xo,ys*yo,z);	
								//System.out.println(squarPrint(uP[uu][nc]));
							}
							//System.out.println((nc)+":\n"+squarPrint(P[nc]));
							nc++;
						}
					}	
				}
			}		
		}	
		for(int q=0; q<14; q++){
			for(int pr=0; pr<24; pr++){
				QP[q][pr] = QxP(Q[q],P[pr].clone());
				PQ[q][pr] = PxQ(P[pr].clone(),Q[q]);
			}
		}
	}
	public static int zeroNum(String mat){
		int n=0;
		for(int s=0; s<mat.length(); s++){
			if(mat.charAt(s)=='0') n++;
		}
		return n;
	}
	public static List<Sign[]> substitutingIs(Sign[] usxQs){
		Sign[] usxQsOrig = usxQs.clone();
		List<Sign[]> InsVecList = new ArrayList<Sign[]>();
		if(usxQsOrig[0].equals(Sign.Ind)|| usxQsOrig[1].equals(Sign.Ind) || usxQsOrig[2].equals(Sign.Ind)){
			if(!usxQsOrig[0].equals(Sign.Ind)){
				if(!usxQsOrig[1].equals(Sign.Ind)){
					if(!usxQsOrig[2].equals(Sign.Ind)) {InsVecList.add(usxQs.clone());}
					else { for(int z=-1; z<2; z++) {usxQs[2]=new Sign(z); InsVecList.add(usxQs.clone());}}
				}else {
					for(int y=-1; y<2; y++) {
						usxQs[1]=new Sign(y);
						if(!usxQsOrig[2].equals(Sign.Ind)) {InsVecList.add(usxQs.clone());}
						else { for(int z=-1; z<2; z++) {usxQs[2]=new Sign(z); InsVecList.add(usxQs.clone());}}
					}
				}
			}else{
				for(int x=-1; x<2; x++){
					usxQs[0]=new Sign(x);
					if(!usxQsOrig[1].equals(Sign.Ind)){
						if(!usxQsOrig[2].equals(Sign.Ind)) {InsVecList.add(usxQs.clone());}
						else { for(int z=-1; z<2; z++) {usxQs[2]=new Sign(z); InsVecList.add(usxQs.clone());}}
					}else {
						for(int y=-1; y<2; y++) {
							usxQs[1]=new Sign(y);
							if(!usxQsOrig[2].equals(Sign.Ind)) {InsVecList.add(usxQs.clone());}
							else {for(int z=-1; z<2; z++) {usxQs[2]=new Sign(z); InsVecList.add(usxQs.clone());}}
						}
					}
				}
			}
		}
		return InsVecList;
		//InsVecList: list of product vectors resulted from substituting Is with possible cases
	}
	public static Sign[] QstrToQsign(String Qstr){
		int len= Qstr.length();
		Sign[] Qs = new Sign[len];
		char[] signs= new char[len];
		Qstr.getChars(0, len, signs, 0);
		for(int q=0; q < len; q++) Qs[q]= new Sign(signs[q]);
		return Qs;

	}

	public static String uxP(String matrix, int xOff, int yOff, int zOff){
		char[] match = new char[3];
		if(xOff < 0) {
			xOff = -xOff-1;
			match[xOff]= negate(matrix.charAt(0));	
		}else{
			xOff -=1;
			match[xOff]= matrix.charAt(0);			
		}

		if(yOff < 0) {
			yOff = -yOff-2;
			match[1+yOff]= negate(matrix.charAt(1));	
		}else{
			yOff -= 2;
			match[1+yOff]= matrix.charAt(1);			
		}

		if(zOff < 0) {
			zOff= -zOff-3;
			match[2+zOff]= negate(matrix.charAt(2));	
		}else{
			zOff-=3;
			match[2+zOff]= matrix.charAt(2);		
		}
		return stringPrint(match);	
	}

	public static String PxQ(int[] perm, String mstr){
		Sign[] m = QstrToQsign(mstr);
		double[] md = new double[m.length];
		for(int i=0; i<m.length; i++){
			md[i] = Sign.signInstantiate(m[i], 1);
		}
		md = PxQ(perm,md);
		String res="";
		Sign s;
		for(int i=0; i<m.length; i++){
			s=new Sign(md[i]);
			res+=s;
		}
		return res;
	}

	public static String QxP(String mstr, int[] perm){
		Sign[] m = QstrToQsign(mstr);
		double[] md = new double[m.length];
		for(int i=0; i<m.length; i++){
			md[i] = Sign.signInstantiate(m[i], 1);
		}
		md = QxP(md,perm);
		String res="";
		Sign s;
		for(int i=0; i<m.length; i++){
			s=new Sign(md[i]);
			res+=s;
		}
		return res;
	}
	public static int[] PxP(int[] Pl, int[] Pr){
		int[] PrT = transpose(Pr);
		int[] PP = new int[9];
		for(int i=0; i<3; i++){//row
			for(int j=0; j < 3; j++){//column
				for(int k=0; k<3; k++){
					PP[i*3+j] += Pl[i*3+k]*PrT[j*3+k];
				}
			}
		}
		return PP;
	}
	public static double[] PxQ(int[] Pr, double[] Qr){
		double[] QrT = transpose(Qr);
		double[] PxQ = new double[9];
		for(int i=0; i<3; i++){//row
			for(int j=0; j < 3; j++){//column
				for(int k=0; k<3; k++){
					PxQ[i*3+j] += Pr[i*3+k]*QrT[j*3+k];
				}
			}
		}
		return PxQ;
	}
	public static double[] QxP(double[] Ql, int[] Pr){
		int[] PrT = transpose(Pr);
		int len = Ql.length;
		double[] QxP = new double[len];
		len/=3;
		for(int i=0; i<len; i++){//row
			for(int j=0; j < 3; j++){//column
				for(int k=0; k<3; k++){
					QxP[i*3+j] += Ql[i*3+k]*PrT[j*3+k];
				}
			}
		}
		return QxP;
	}
	public static Sign[] usxQs(Sign[] usign, Sign[] Qu){
		Sign[] usxQs = new Sign[3];
		Sign[] TQsign= new Sign[9];//Transpose of Q[j], just for making the cross product of usign and Qsign easier
		for(int j=0; j<3; j++){
			for(int k=0; k<3; k++){
				TQsign[k*3+j] = new Sign(Qu[j*3+k]);				
			}
		}
		usxQs[0] = Sign.sum3(Sign.dot2(usign[0],TQsign[0*3+0]), Sign.dot2(usign[1],TQsign[0*3+1]), Sign.dot2(usign[2],TQsign[0*3+2]));
		usxQs[1] = Sign.sum3(Sign.dot2(usign[0],TQsign[1*3+0]), Sign.dot2(usign[1],TQsign[1*3+1]), Sign.dot2(usign[2],TQsign[1*3+2]));
		usxQs[2] = Sign.sum3(Sign.dot2(usign[0],TQsign[2*3+0]), Sign.dot2(usign[1],TQsign[2*3+1]), Sign.dot2(usign[2],TQsign[2*3+2]));
		return usxQs;
	}
	public static double[] QrandomInstan(int q){
		double[] Qi = new double[9];
		Sign[] Qs = QstrToQsign(Q[q]);
		Random rn = new Random();
		int lim = 1000;
		if(q<4){
			while(true){
				Qi[0]= Sign.signInstantiate(Qs[0], rn.nextInt(lim)+1);
				Qi[1]= Sign.signInstantiate(Qs[1], rn.nextInt(lim)+1);
				Qi[2]= Sign.signInstantiate(Qs[2], rn.nextInt(lim)+1);
				Qi[3]= Sign.signInstantiate(Qs[3], rn.nextInt(lim)+1);
				Qi[4]= Sign.signInstantiate(Qs[4], rn.nextInt(lim)+1);
				Qi[8]= Sign.signInstantiate(Qs[8], rn.nextInt(lim)+1);
				Qi[5]= -(Qi[0]*Qi[3]+Qi[1]*Qi[4])/Qi[2];
				if(!Qs[5].equals(Qi[5])) continue;
				else{
					Qi[6] = Qi[8]*(Qi[2]*Qi[4]-Qi[1]*Qi[5])/(Qi[1]*Qi[3]-Qi[0]*Qi[4]);
					Qi[7] = -(Qi[0]*Qi[6]+Qi[2]*Qi[8])/Qi[1];
					if(Qs[6].equals(Qi[6]) && Qs[7].equals(Qi[7])) break;
				}
			}
		}else if(q==4 || q==9){
			while(true){
				Qi[0]= Sign.signInstantiate(Qs[0], rn.nextInt(lim)+1);
				Qi[1]= Sign.signInstantiate(Qs[1], rn.nextInt(lim)+1);
				Qi[2]= 0;
				Qi[3]= Sign.signInstantiate(Qs[3], rn.nextInt(lim)+1);
				Qi[6]= Sign.signInstantiate(Qs[6], rn.nextInt(lim)+1);
				Qi[4]= -Qi[0]*Qi[3]/Qi[1];			
				Qi[7]= -Qi[0]*Qi[6]/Qi[1];			
				if((!Qs[4].equals(Qi[4])) || (!Qs[7].equals(Qi[7]))) continue;
				else{
					Qi[5]= Sign.signInstantiate(Qs[5], rn.nextInt(lim)+1);
					Qi[8] = -(Qi[3]*Qi[6]+Qi[4]*Qi[7])/Qi[5];
					if(Qs[8].equals(Qi[8])) break;
				}
			}
		}else if(q==5 || q==8){
			while(true){
				Qi[0]= Sign.signInstantiate(Qs[0], rn.nextInt(lim)+1);
				Qi[3]= Sign.signInstantiate(Qs[3], rn.nextInt(lim)+1);
				Qi[4]= 0;
				Qi[5]= Sign.signInstantiate(Qs[5], rn.nextInt(lim)+1);
				Qi[6]= Sign.signInstantiate(Qs[6], rn.nextInt(lim)+1);
				Qi[2]= -Qi[0]*Qi[3]/Qi[5];			
				Qi[8]= -Qi[3]*Qi[6]/Qi[5];			
				if((!Qs[2].equals(Qi[2])) || (!Qs[8].equals(Qi[8]))) continue;
				else{
					Qi[1]= Sign.signInstantiate(Qs[1], rn.nextInt(lim)+1);
					Qi[7] = -(Qi[0]*Qi[6]+Qi[2]*Qi[8])/Qi[1];
					if(Qs[7].equals(Qi[7])) break;
				}
			}
		}else if(q==6 || q==7){			
			while(true){
				Qi[0]= Sign.signInstantiate(Qs[0], rn.nextInt(lim)+1);
				Qi[3]= Sign.signInstantiate(Qs[3], rn.nextInt(lim)+1);
				Qi[6]= Sign.signInstantiate(Qs[6], rn.nextInt(lim)+1);
				Qi[7]= Sign.signInstantiate(Qs[7], rn.nextInt(lim)+1);
				Qi[8]=0;
				Qi[1]= -Qi[0]*Qi[6]/Qi[7];	
				Qi[4]= -Qi[3]*Qi[6]/Qi[7];					
				if((!Qs[1].equals(Qi[1])) || (!Qs[4].equals(Qi[4]))) continue;
				else{
					Qi[2]= Sign.signInstantiate(Qs[2], rn.nextInt(lim)+1);
					Qi[5] = -(Qi[0]*Qi[3]+Qi[1]*Qi[4])/Qi[2];
					if(Qs[5].equals(Qi[5])) break;
				}
			}			
		}else{
			Qi[0]= rn.nextInt(lim)+1;
			Qi[4]= rn.nextInt(lim)+1;
			Qi[8]= rn.nextInt(lim)+1;		
			if(q==10){
				Qi[7]= rn.nextInt(lim)+1;		
				Qi[5]= -Qi[4]*Qi[7]/Qi[8];	
			}else if(q==11){
				Qi[6]= rn.nextInt(lim)+1;		
				Qi[2]= -Qi[0]*Qi[6]/Qi[8];	
			}else if(q==12){
				Qi[3]= rn.nextInt(lim)+1;		
				Qi[1]= -Qi[0]*Qi[3]/Qi[4];	
			}
		}
		return normalize(Qi);	
	}
	public static double[] uvxQv(double[] uv,double[] Qv){
		double[] TQv = transpose(Qv);
		double[] product = new double[3];
		for(int j=0; j<3; j++){
			for(int k=0; k<3; k++){
				product[j] += (uv[k]*TQv[3*j+k]);
			}
		}
		return product.clone();
	}

	public static double[] MlxMr(double[] Ml,double[] Mr){
		double[] TMr = transpose(Mr);
		int len = Ml.length;
		double[] product = new double[len];
		len/=3;
		for(int i=0; i<len; i++){
			for(int j=0; j<3; j++){
				for(int k=0; k<3; k++){
					product[3*i+j] += (Ml[3*i+k]*TMr[3*j+k]);
				}
			}
		}
		return product.clone();
	}

	public static void factorToPQ(String R){
		outerLoop:
			for(int q=0; q<14; q++){
				for(int p=0; p<24; p++ ){
					if(PQ[q][p].equals(R)){
						System.out.println("q= "+q+"  p= "+ p +"    PQ:");
						System.out.println(PQ[q][p]);
						qInx= q;
						pInx= p;
						break outerLoop;
					}
					if(q==13 && p==23)System.out.println("The specified Matrix, was not found, it is not right-handed sign matrix");
				}			
			}

	}
	public static void factorToQP(String R){
		outerLoop:
			for(int q=0; q<14; q++){
				for(int p=0; p<24; p++ ){
					if(QP[q][p].equals(R)){
						qInx= q;
						pInx= p;
						break outerLoop;
					}
					if(q==13 && p==23)System.out.println("The specified Matrix, was not found, it is not right-handed sign matrix");
				}			
			}

	}
	public static void factorToUP(String V){//returns u index
		int id=0;
		switch(zeroNum(V)){
		case 2:{
			uInx =0;
			for(int p=0; p<24; p++ )
				if(uP[0][p].equals(V))
					vpInx[id++] = p;
			break;
		}
		case 1:{
			uInx =1;
			for(int p=0; p<24; p++ )
				if(uP[1][p].equals(V))
					vpInx[id++] = p;
			break;
		}
		case 0:{
			uInx =2;
			for(int p=0; p<24; p++ )
				if(uP[2][p].equals(V))
					vpInx[id++] = p;
			break;
		}
		//finally
		//System.out.println("The specified Vector, was not found : "+ squarPrint(V));										
		}				
	}

	public static String getSignString(double[] matrix){
		char[] signst = new char[matrix.length];
		for(int i=0; i<matrix.length; i++){
			if(matrix[i] > 0) signst[i] = '+';
			else if (matrix[i] < 0) signst[i] = '-';
			else signst[i] = '0';

		}
		System.out.println(stringPrint(signst));
		return stringPrint(signst);
	}
	public static void QxQinstantiatTranspose(){
		HashSet<String> hset = new HashSet<String>();
		HashMap<String,String> TinstancesMap = new HashMap<String,String>();
		try{
			for(int i=0; i<14; i++){			
				for(int j=0; j<14; j++){
					hset = new HashSet<String>();
					TinstancesMap = new HashMap<String,String>();
					String k=Q[i]+Q[j];
					String Q2T = transpose(Q[j]);
					String Q1T = transpose(Q[i]);
					int[] transindices = RxSfactor(Q2T, Q1T);
					String transposeKey = Q[transindices[0]]+Q[transindices[1]];
					BufferedReader in = new BufferedReader(new FileReader("QxQinstances.txt")); 					
					String s=in.readLine();
					while(s!=null){
						if(s.substring(0, 18).equals(k)){
							String[] res = s.split(" ");
							//System.out.println("case: "+res[1]);
							hset.add(res[1]);
						}else if(s.substring(0, 18).equals(transposeKey)){							
							String[] tran = s.split(" ");
							String trasProd =QxP(tran[1], P[transindices[2]]);
							trasProd = transpose(trasProd);	
							TinstancesMap.put(trasProd, s);
						}
						s = in.readLine();
					}
					in.close();
					
					//////////////////////////////////////////////////////
					
					FileWriter fstream1 = new FileWriter("QxQinstances.txt", true);
					BufferedWriter out = new BufferedWriter(fstream1);
					for(String prodT: TinstancesMap.keySet()){
						if(!hset.contains(prodT)){
							//System.out.println("New Entry!");
							String[] instanceArr = TinstancesMap.get(prodT).split(" ");
							String[] M1 = new String[9];
							String[] M2 = new String[9];
							for(int t=0; t<9; t++){
								M1[t] = instanceArr[2+t];
								M2[t] = instanceArr[11+t];
							}
							double[] dM1 = new double[9];
							double[] dM2 = new double[9];
							double[] dMp = new double[9];
							for(int t=0; t<9; t++){
								dM1[t] = Double.parseDouble(M1[t]);
								dM2[t] = Double.parseDouble(M2[t]);
							}
							double[] M1P = QxP(dM1,P[transindices[3]]);
							double[] M2P = QxP(PxQ(transpose(P[transindices[3]]),dM2),P[transindices[2]]);
							M1P = transpose(M1P);
							M2P = transpose(M2P);
						    out.write(Q[i]+Q[j]+" "+prodT+" ");
							out.write(stringPrint(M2P));
							out.write(stringPrint(M1P));
							out.newLine();
//							System.out.println(squarPrint(Q[i]));
//							System.out.println(squarPrint(Q[j]));
//							System.out.println(squarPrint(prodT));
//							System.out.println(squarPrint(M2P));
//							System.out.println(squarPrint(M1P));
//							System.out.println(squarPrint(MlxMr(M2P, M1P)));
//							System.out.println("-----------------------------");
						}
					}
					out.close();					
				}
			}

		}catch(Exception e){
			e.printStackTrace();
		}
	}
	public static void QxQinstantiatRandomly(){
		double[] QiIns = new double[9];
		double[] QjIns = new double[9];
		double[] QixjIns = new double[9];
		HashSet<String> hset = new HashSet<String>();
		try{
			for(int i=0; i<14; i++){			
				for(int j=0; j<14; j++){
					hset = new HashSet<String>();
					String k=Q[i]+Q[j];
					BufferedReader in = new BufferedReader(new FileReader("QxQinstances.txt")); 					
					String s=in.readLine();
					while(s!=null){
						if(s.substring(0, 18).equals(k)){
							String[] res = s.split(" ");
							System.out.println("case: "+res[1]);
							hset.add(res[1]);
						}
						s = in.readLine();
					}
					in.close();
					FileWriter fstream1 = new FileWriter("QxQinstances.txt", true);
					BufferedWriter out = new BufferedWriter(fstream1);
					for(int n=0; n<10000; n++){
						QiIns = QrandomInstan(i);
						QjIns = QrandomInstan(j);
						QixjIns = MlxMr(QiIns, QjIns);
						String Qixj = getSignString(QixjIns);
						if(!hset.contains(Qixj)){
							System.out.println("New Entry!");
							hset.add(Qixj);
							out.write(Q[i]+Q[j]+" "+Qixj+" ");
							out.write(stringPrint(QiIns));
							out.write(stringPrint(QjIns));
							out.newLine();
						}
					}
					out.close();					
				}
			}

		}catch(Exception e){
			e.printStackTrace();
		}
	}
	public static void instanceCounter(){
		try{
			for(int i=0; i<14; i++){			
				for(int j=0; j<14; j++){
					String k=Q[i]+Q[j];
					int n=0;
					BufferedReader in = new BufferedReader(new FileReader("QxQinstances.txt")); 					
					String s=in.readLine();
					while(s!=null){
						if(s.substring(0, 18).equals(k)) n++;
						s = in.readLine();
					}
					System.out.print(n+"  ");
					in.close();					
				}
				System.out.println();
			}

		}catch(Exception e){
			e.printStackTrace();
		}

	}
	public static int[] RxSfactor(String R, String S){
		int[] indices =new int[4];
		factorToQP(R);
		int pr = pInx;
		int qr = qInx;
		String PRxS = PxQ(P[pInx],S);
		factorToQP(PRxS);
		indices[0] = qr;
		indices[1] = qInx;
		indices[2] = pInx;
		indices[3] = pr;
		return indices;
	}
	public static void RxS(String R, String S){	
		
		factorToQP(R);
		int qr = qInx;
		int pr = pInx;
		String PRxS = PxQ(P[pInx],S);
		factorToQP(PRxS);
		System.out.println("Q"+(qr+1)+"      \u00D7     Q"+(qInx+1)+"    \u00D7     P"+(pInx+1));
		System.out.println(squarPrintfactorizingRxS(Q[qr], Q[qInx], P[pInx]));

		int solCoun=0;
		try{
			BufferedReader in = new BufferedReader(new FileReader("QxQinstances.txt")); 
			String k=Q[qr]+Q[qInx];
			String s=in.readLine();
			while(s!=null){
				if(s.substring(0, 18).equals(k)){
					String[] res = s.split(" ");
					double[] QR = new double[9];
					double[] QS = new double[9];
					double[] QRxQS = new double[9];
					String psign;
					int i=1;
					if(!res[i].equals(null)){
						psign = res[i];
						i++;
						for (int j = 0; j < 9; j++) {
							QR[j] = Double.parseDouble(res[i+j]);
						}
						i+=9;
						for (int j = 0; j < 9; j++) {
							QS[j] = Double.parseDouble(res[i+j]);
						}
						i+=9;
						QR = QxP(QR,P[pr]);
						QS = PxQ(transpose(P[pr]),QxP(QS,P[pInx]));
						QRxQS = MlxMr(QR, QS);
						psign = QxP(psign,P[pInx]); 
						System.out.println("________________________________________"+(++solCoun));
						System.out.println(squarPrintMxMP(RLM, RRM, psign));
						System.out.println(squarPrintRSP(QR, QS, QRxQS));
					} 
				}
				s = in.readLine();
			}

		}catch(Exception e){
			System.out.println(e.getMessage());
		}
	}

	public static void vxR(String V, String R){
		factorToUP(V);
		String PvxR = PxQ(P[vpInx[0]].clone(),R);
		factorToQP(PvxR);
		System.out.println("U"+(uInx+1)+"      \u00D7   Q"+(qInx+1)+"    \u00D7   P"+(pInx+1));
		System.out.println(squarPrintfactorizingvxR(u[uInx],Q[qInx],P[pInx]));
		try{
			BufferedReader in = new BufferedReader(new FileReader("uxQintances.txt")); 
			String k=u[uInx]+Q[qInx];
			String s = in.readLine();
			while(!s.substring(0, 12).equals(k)) s = in.readLine();
			String[] res = s.split(" ");
			double[] dv = new double[3];
			double[] Qv = new double[9];
			double[] dvxQv = new double[3];
			String psign;
			int i=1;
			int solCoun=0;
			while(!res[i].equals(null)){
				psign = res[i];
				//psign2 = psign.charAt(0)+" "+psign.charAt(1)+" "+psign.charAt(2);
				i++;
				dv[0] = Double.parseDouble(res[i]);
				dv[1] = Double.parseDouble(res[i+1]);
				dv[2] = Double.parseDouble(res[i+2]);
				i+=3;
				for (int j = 0; j < 9; j++) {
					Qv[j] = Double.parseDouble(res[i+j]);
				}
				i+=9;
				dv = QxP(dv,P[vpInx[0]]);
				Qv = PxQ(transpose(P[vpInx[0]]),QxP(Qv,P[pInx]));
				dvxQv = uvxQv(dv, Qv);
				psign = QxP(psign,P[pInx]); 

				System.out.println("________________________________________"+(++solCoun));
				System.out.println(squarPrintvxMP(Vec,RRM,psign));
				System.out.println(squarPrintVRP(dv, Qv, dvxQv));
			}						
		}catch(Exception e){
			System.out.println(e.getMessage());
		}
	}


	public static double[] normalize(double[] Qi){
		int len = Qi.length;
		len/=3;
		for(int i=0; i<len; i++){
			double norm= vecLength(Qi[3*i+0], Qi[3*i+1], Qi[3*i+2]);
			Qi[3*i+0]/=norm;	  Qi[3*i+1]/=norm;	  Qi[3*i+2]/=norm;			
		}
		return Qi;
	}
	public static double[] secondRowQ1(Sign[] us, double[] Qi, Sign[] Ps, double[] v){
		//I'm going to assum here that there won't be any us passed to this method more than one zero
		int itnum =10;
		int lim =1000;
		Random rn = new Random();
		double[] ui = new double[]{0,0,0};
		double[] pi = new double[]{0,0,0};
		do{
			ui = new double[]{0,0,0};
			pi = new double[]{0,0,0};
			if(Ps[1].equals(Sign.Zer) && Ps[2].equals(Sign.Zer) ){
				double A = ((Qi[1]*Qi[8]-Qi[2]*Qi[7])/(Qi[5]*Qi[7]-Qi[4]*Qi[8]));
				ui[0] = Math.pow(v[0]*Qi[7]+v[1]*A*Qi[7]-v[2]*Qi[1]-v[2]*A*Qi[4], -1);
				ui[1] = ui[0]*A;
				ui[2] = -(ui[0]*Qi[1]+ui[1]*Qi[4])/Qi[7];				    	 

			}else if(Ps[0].equals(Sign.Zer) && Ps[2].equals(Sign.Zer) ){
				//System.out.print("The case of P[0] and P[2] is zero");
				double A = ((Qi[2]*Qi[6]-Qi[0]*Qi[8])/(Qi[3]*Qi[8]-Qi[5]*Qi[6]));
				ui[0] = Math.pow(v[0]*Qi[8]+v[1]*A*Qi[8]-v[2]*Qi[2]-v[2]*A*Qi[5], -1);
				ui[1] = ui[0]*A;
				ui[2] = -(ui[0]*Qi[2]+ui[1]*Qi[5])/Qi[8];				    	 

			}else if(Ps[0].equals(Sign.Zer) && Ps[1].equals(Sign.Zer) ){
				// System.out.print("The case of P[0] and P[1] is zero");
				double A = ((Qi[1]*Qi[6]-Qi[0]*Qi[2])/(Qi[3]*Qi[7]-Qi[4]*Qi[6]));
				ui[0] = Math.pow(v[0]*Qi[7]+v[1]*A*Qi[7]-v[2]*Qi[1]-v[2]*A*Qi[4], -1);
				ui[1] = ui[0]*A;
				ui[2] = -(ui[0]*Qi[1]+ui[1]*Qi[4])/Qi[7];				    	 
				//TODO below needs to take care of the case in which one of the uis is zero
				//there is nothing that I can do for two zeros here
			}else if(Ps[2].equals(Sign.Zer)){
				if(!us[1].equals(Sign.Zer) && !us[2].equals(Sign.Zer) ){
					ui[0] = Sign.signInstantiate(us[0], rn.nextInt(lim));
					ui[1] = -ui[0]*(v[0]*Qi[8]-v[2]*Qi[2])/(v[1]*Qi[8]-v[2]*Qi[5]);						  
					ui[2] = -(ui[0]*Qi[2]+ui[1]*Qi[5])/Qi[8];
				}else if(!us[2].equals(Sign.Zer) && !us[0].equals(Sign.Zer) ){
					ui[1] = Sign.signInstantiate(us[1], rn.nextInt(lim));
					ui[0] = -ui[1]*(v[1]*Qi[8]-v[2]*Qi[5])/(v[0]*Qi[8]-v[2]*Qi[2]);						  
					ui[2] = -(ui[0]*Qi[2]+ui[1]*Qi[5])/Qi[8];
				}else if(!us[0].equals(Sign.Zer) && !us[1].equals(Sign.Zer) ){
					ui[2] = Sign.signInstantiate(us[2], rn.nextInt(lim));
					ui[1] = -ui[2]*(v[2]*Qi[2]-v[0]*Qi[8])/(v[1]*Qi[2]-v[0]*Qi[5]);						  
					ui[0] = -(ui[2]*Qi[8]+ui[1]*Qi[5])/Qi[2];
				}
			}else if(Ps[1].equals(Sign.Zer)){
				if(!us[1].equals(Sign.Zer) && !us[2].equals(Sign.Zer) ){
					ui[0] = Sign.signInstantiate(us[0], rn.nextInt(lim));
					ui[1] = -ui[0]*(v[0]*Qi[7]-v[2]*Qi[1])/(v[1]*Qi[7]-v[2]*Qi[4]);	
					ui[2] = -(ui[0]*Qi[1]+ui[1]*Qi[4])/Qi[7];
				}else if(!us[2].equals(Sign.Zer) && !us[0].equals(Sign.Zer) ){
					ui[1] = Sign.signInstantiate(us[1], rn.nextInt(lim));
					ui[0] = -ui[1]*(v[1]*Qi[7]-v[2]*Qi[4])/(v[0]*Qi[7]-v[2]*Qi[1]);	
					ui[2] = -(ui[0]*Qi[1]+ui[1]*Qi[4])/Qi[7];						  
				}else if(!us[0].equals(Sign.Zer) && !us[1].equals(Sign.Zer) ){
					ui[2] = Sign.signInstantiate(us[2], rn.nextInt(lim));
					ui[1] = -ui[2]*(v[2]*Qi[1]-v[0]*Qi[7])/(v[1]*Qi[1]-v[0]*Qi[4]);						  
					ui[0] = -(ui[2]*Qi[7]+ui[1]*Qi[4])/Qi[1];						  
				}
			}else if(Ps[0].equals(Sign.Zer)){
				if(!us[1].equals(Sign.Zer) && !us[2].equals(Sign.Zer) ){
					ui[0] = Sign.signInstantiate(us[0], rn.nextInt(lim));
					ui[1] = -ui[0]*(v[0]*Qi[6]-v[2]*Qi[0])/(v[1]*Qi[6]-v[2]*Qi[3]);	
					ui[2] = -(ui[0]*Qi[0]+ui[1]*Qi[3])/Qi[6];
				}else if(!us[2].equals(Sign.Zer) && !us[0].equals(Sign.Zer) ){
					ui[1] = Sign.signInstantiate(us[1], rn.nextInt(lim));
					ui[0] = -ui[1]*(v[1]*Qi[6]-v[2]*Qi[3])/(v[0]*Qi[6]-v[2]*Qi[0]);	
					ui[2] = -(ui[0]*Qi[0]+ui[1]*Qi[3])/Qi[6];						  
				}else if(!us[0].equals(Sign.Zer) && !us[1].equals(Sign.Zer) ){
					ui[2] = Sign.signInstantiate(us[2], rn.nextInt(lim));
					ui[1] = -ui[2]*(v[2]*Qi[0]-v[0]*Qi[6])/(v[1]*Qi[0]-v[0]*Qi[3]);						  
					ui[0] = -(ui[2]*Qi[6]+ui[1]*Qi[3])/Qi[0];								  
				}
			}else{
				ui[0] = Sign.signInstantiate(us[0], rn.nextInt(lim));
				ui[1] = Sign.signInstantiate(us[1], rn.nextInt(lim));
				ui[2] = Sign.signInstantiate(us[2], rn.nextInt(lim));
				if(v[0]!=0)
					ui[0] = -(ui[1]*v[1]+ui[2]*v[2])/v[0];
				else if(v[1]!=0)
					ui[1] = -(ui[0]*v[0]+ui[2]*v[2])/v[1];
				else
					ui[2] = -(ui[1]*v[1]+ui[0]*v[0])/v[2];
			}
			//System.out.println(ui[0]+ "  " +ui[1]+ "  " +ui[2]);
			pi = MlxMr(ui, Qi);
			if(patternMatching(us, ui) && patternMatching(Ps, pi)) {
				//System.out.println("--------found----");
				return ui;
			}
			itnum--;
		} while(itnum > 0);
		return null;
	}
	public static double[] uxQRandomIns(int uind, int Qind, double[] Qi, Sign[] Ps){
		Random rn = new Random();
		double of=1;
		int lim=1000;
		double[] ui = new double[3];
		int itnum=1000;
		switch(Qind){
		case 0:{		  
			if(uind==2){//Solving the special case of P=+ 0 0
				do{		      
					do{ ui[0] = rn.nextInt(lim); }while(ui[0]<=0);
					ui[1] = ui[0]*((Qi[1]*Qi[8]-Qi[2]*Qi[7])/(Qi[5]*Qi[7]-Qi[4]*Qi[8]));
					ui[2] = -(ui[0]*Qi[1]+ui[1]*Qi[4])/Qi[7];
					if(Ps[1].equals(Sign.Pos)){ 
						ui[0]+=of; ui[1]-=of*(Qi[2]/Qi[5]);
					}else if (Ps[1].equals(Sign.Neg)){ 
						ui[0]-=of; ui[1]+=of*(Qi[2]/Qi[5]);
					}
					if(Ps[2].equals(Sign.Pos)){ 
						ui[0]+=of; ui[2]-=of*(Qi[1]/Qi[7]);
					}else if (Ps[2].equals(Sign.Neg)){ 
						ui[0]-=of; ui[2]+=of*(Qi[1]/Qi[7]);
					}
					itnum--;
				}while((ui[0]<=0 || ui[1] <= 0 || ui[2] <=0) && itnum>0);
			}else if(uind==1){//Solving the special case of P=+ 0 +
				do{ ui[0] = rn.nextInt(lim);}while(ui[0]==0);
				ui[1] =-(ui[0]*Qi[1])/Qi[4];		
				ui[2] = 0;
				if(Ps[1].equals(Sign.Pos)){ 
					ui[0]*=2;
				}else if (Ps[1].equals(Sign.Neg)){ 
					ui[1]*=2;
				}
			}else if(uind==0){
				do{ ui[0] = rn.nextInt(lim);}while(ui[0]==0);
			}
			break;	
		} 
		case 1:{		  
			if(uind==2){//Solving the special case of P=+ 0 0
				do{
					do ui[0] = rn.nextInt(lim); while(ui[0]==0);
					ui[1] = ui[0]*((Qi[1]*Qi[8]-Qi[2]*Qi[7])/(Qi[5]*Qi[7]-Qi[4]*Qi[8]));
					ui[2] = -(ui[0]*Qi[1]+ui[1]*Qi[4])/Qi[7];

					if(Ps[1].equals(Sign.Pos)){ 
						ui[0]+=of*(Qi[5]/Qi[2]); ui[1]-=of;
					}else if (Ps[1].equals(Sign.Neg)){ 
						ui[0]-=of*(Qi[5]/Qi[2]); ui[1]+=of;
					}
					if(Ps[2].equals(Sign.Pos)){ 
						ui[1]+=of; ui[2]-=of*(Qi[4]/Qi[7]);
					}else if (Ps[2].equals(Sign.Neg)){ 
						ui[1]-=of; ui[2]+=of*(Qi[4]/Qi[7]);
					}
					itnum--;
				}while((ui[0]<=0 || ui[1] <= 0 || ui[2] <=0) && itnum>0);
			}else if(uind==1){//Solving the special case of P=+ 0 +
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
				ui[1] =-(ui[0]*Qi[1])/Qi[4];		
				ui[2] = 0;
				if(Ps[1].equals(Sign.Pos)){ 
					ui[0]*=2;
				}else if (Ps[1].equals(Sign.Neg)){ 
					ui[1]*=2;
				}
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
			}		  			
			break;	
		}
		case 2:{		  					  
			if(uind==2){//Solving the special case of P=+ 0 0
				do{
					do ui[0] = rn.nextInt(lim); while(ui[0]==0);
					ui[1] = ui[0]*((Qi[1]*Qi[8]-Qi[2]*Qi[7])/(Qi[5]*Qi[7]-Qi[4]*Qi[8]));
					ui[2] = -(ui[0]*Qi[1]+ui[1]*Qi[4])/Qi[7];

					if(Ps[1].equals(Sign.Pos)){ 
						ui[1]-=of*(Qi[8]/Qi[5]);   ui[2]+=of; 
					}else if (Ps[1].equals(Sign.Neg)){ 
						ui[1]+=of*(Qi[8]/Qi[5]);   ui[2]-=of;
					}
					if(Ps[2].equals(Sign.Pos)){ 
						ui[0]+=of*(Qi[7]/Qi[1]); ui[2]-=of;
					}else if (Ps[2].equals(Sign.Neg)){ 
						ui[0]-=of*(Qi[7]/Qi[1]); ui[2]+=of;
					}
					itnum--;
				}while((ui[0]<=0 || ui[1] <= 0 || ui[2] <=0) && itnum>0);
			}else if(uind==1){//Solving the special case of P=+ 0 0
				if(((Ps[1].equals(Sign.Pos) || Ps[1].equals(Sign.Zer))&&(!Ps[2].equals(Sign.Pos))) ||
						((Ps[2].equals(Sign.Neg)|| Ps[2].equals(Sign.Zer))&&(!Ps[1].equals(Sign.Neg)))	  ){
					// System.out.println("This case is not instantiable : + + 0 * Q2 = "+Ps[0]+Ps[1]+Ps[2]);
					return null;
				}
				do{//solving the special case of + - +
					do {ui[0] = rn.nextInt(lim); ui[1] = rn.nextInt(lim); }while(ui[0]==0 || ui[1]==0);
				}while((ui[0]*Qi[1]+ui[1]*Qi[4]>0)||(ui[0]*Qi[2]+ui[1]*Qi[5]<0 ));

				if(Ps[1].equals(Sign.Neg)){ 
					ui[1] =-(ui[0]*Qi[2])/Qi[5];
					if(Ps[2].equals(Sign.Zer))break;//+-0
					else if(Ps[2].equals(Sign.Neg)){//+--
						ui[1]*=2;
						break;
					}
				}
				if(Ps[2].equals(Sign.Pos)){
					ui[1] =-(ui[0]*Qi[1])/Qi[4];
					if(Ps[1].equals(Sign.Zer))break;//+0+
					else if(Ps[1].equals(Sign.Pos)){//+++
						ui[0]*=2;
						break;
					}
				}
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
			}		  			
			break;	
		}

		case 3:{		  					  
			if(uind==2){//Solving the special case of P=+ 0 0
				// do{
				if((Ps[0].equals(Sign.Zer)|| (Ps[0].equals(Sign.Neg))) && 
						(!Ps[1].equals(Sign.Pos)|| (!Ps[2].equals(Sign.Neg))))
				{ //System.out.println("This case is not instantiable : + + + * Q3 = "+Ps[0]+Ps[1]+Ps[2]); 
					return null;}
				else if((Ps[1].equals(Sign.Zer)|| (Ps[1].equals(Sign.Neg))) && 
						(!Ps[0].equals(Sign.Pos)|| (!Ps[2].equals(Sign.Neg))))
				{  //System.out.println("This case is not instantiable : + + + * Q3 = "+Ps[0]+Ps[1]+Ps[2]);
					return null;}
				else if((Ps[2].equals(Sign.Zer)|| (Ps[2].equals(Sign.Pos))) && 
						(!Ps[0].equals(Sign.Pos)|| (!Ps[1].equals(Sign.Pos))))
				{ //System.out.println("This case is not instantiable : + + + * Q3 = "+Ps[0]+Ps[1]+Ps[2]);
					return null;}

				do{//solving the special case of + + -
					do {ui[0] = rn.nextInt(lim); ui[1] = rn.nextInt(lim); ui[2] = rn.nextInt(lim);}while(ui[0]==0 || ui[1]==0 || ui[2]==0);
				}while((ui[0]*Qi[0]+ui[1]*Qi[3]+ui[2]*Qi[6] < 0)  ||
						(ui[0]*Qi[1]+ui[1]*Qi[4]+ui[2]*Qi[7] < 0) ||
						(ui[0]*Qi[2]+ui[1]*Qi[5]+ui[2]*Qi[8] >0 ));

				if(Ps[1].equals(Sign.Pos) && Ps[2].equals(Sign.Neg) ){ 
					ui[2] =-(ui[0]*Qi[0]+ui[1]*Qi[3])/Qi[6];//solving special case of P: 0 + - 	
					if(Ps[0].equals(Sign.Zer))break;//0+-
					else if(Ps[0].equals(Sign.Neg)){//-+-
						ui[2]*=2;
						break;
					}
				}
				if(Ps[0].equals(Sign.Pos) && Ps[2].equals(Sign.Neg) ){ 
					ui[1] =-(ui[0]*Qi[1]+ui[2]*Qi[7])/Qi[4];//solving special case of P: + 0 - 		
					if(Ps[1].equals(Sign.Zer))break;//+0-
					else if(Ps[1].equals(Sign.Neg)){//+--
						ui[1]*=2;
						break;
					}
				}
				if(Ps[0].equals(Sign.Pos) && Ps[1].equals(Sign.Pos) ){ 
					ui[0] =-(ui[1]*Qi[5]+ui[2]*Qi[8])/Qi[2];//solving special case of P: + + 0
					if(Ps[2].equals(Sign.Zer))break;//++0
					else if(Ps[2].equals(Sign.Pos)){//+++
						ui[0]*=2;
						break;
					}
				}
				itnum--;
				// }while((ui[0]<=0 || ui[1] <= 0 || ui[2] <=0) && itnum>0);
			}else if(uind==1){//Solving the special case of P=+ 0 0
				if((Ps[1].equals(Sign.Zer)|| (Ps[1].equals(Sign.Neg))) && (!Ps[2].equals(Sign.Neg)))
				{ //System.out.println("This case is not instantiable : + + 0 * Q3 = "+Ps[0]+Ps[1]+Ps[2]);
					return null;}
				else if((Ps[2].equals(Sign.Zer)|| (Ps[2].equals(Sign.Pos))) && (!Ps[1].equals(Sign.Pos)))
				{ //System.out.println("This case is not instantiable : + + 0 * Q3 = "+Ps[0]+Ps[1]+Ps[2]);
					return null;}
				ui[2] = 0;
				do{//solving the special case of + + -
					do {ui[0] = rn.nextInt(lim); ui[1] = rn.nextInt(lim); }while(ui[0]==0 || ui[1]==0);
				}while((ui[0]*Qi[1]+ui[1]*Qi[4]<0)||(ui[0]*Qi[2]+ui[1]*Qi[5]>0));

				if(Ps[2].equals(Sign.Neg) ){ 
					ui[1] =-(ui[0]*Qi[1])/Qi[4];//solving special case of P: + 0 - 		
					if(Ps[1].equals(Sign.Zer))break;//+0-
					else if(Ps[1].equals(Sign.Neg)){//+--
						ui[1]*=2;
						break;
					}
				}
				if(Ps[1].equals(Sign.Pos) ){ 
					ui[0] =-(ui[1]*Qi[5])/Qi[2];//solving special case of P: + + 0
					if(Ps[2].equals(Sign.Zer))break;//++0
					else if(Ps[2].equals(Sign.Pos)){//+++
						ui[0]*=2;
						break;
					}
				}
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0); 
			}		  			
			break;	
		}
		case 4:{		  
			if(uind==2){
				if((Ps[0].equals(Sign.Zer)|| (Ps[0].equals(Sign.Neg))) && 
						(Ps[1].equals(Sign.Zer)|| (Ps[1].equals(Sign.Neg))))
				{ //System.out.println("This case is not instantiable : + + + *Q4 = "+Ps[0]+Ps[1]+Ps[2]);
					return null;}

				do{//solving the special case of + + +
					do {ui[0] = rn.nextInt(lim); ui[1] = rn.nextInt(lim); ui[2] = rn.nextInt(lim);}while(ui[0]==0 || ui[1]==0 || ui[2]==0);
				}while((ui[0]*Qi[0]+ui[1]*Qi[3]+ui[2]*Qi[6]<0)||(ui[0]*Qi[1]+ui[1]*Qi[4]+ui[2]*Qi[7]<0));

				if(Ps[1].equals(Sign.Pos) && Ps[2].equals(Sign.Pos) ){ 
					ui[1] =-(ui[0]*Qi[0]+ui[2]*Qi[6])/Qi[3];//solving the special case of P: 0 + + 	
					if(Ps[0].equals(Sign.Zer))break;//0++
					else if(Ps[0].equals(Sign.Neg)){//-++
						ui[1]*=2;
						break;
					}
				}
				if(Ps[0].equals(Sign.Pos) && Ps[2].equals(Sign.Pos) ){ 
					ui[2] =-(ui[0]*Qi[1]+ui[1]*Qi[4])/Qi[7];//solving special case of P: + 0 + 		
					if(Ps[1].equals(Sign.Zer))break;//+0+
					else if(Ps[1].equals(Sign.Neg)){//+-+
						ui[2]*=2;
						break;
					}
				}

			}else if(uind==1){//Solving the special case of P=0 + +
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
				ui[1] =-(ui[0]*Qi[0])/Qi[3];		
				ui[2] = 0;
				if(Ps[0].equals(Sign.Pos)){ 
					ui[0]*=2;
				}else if (Ps[0].equals(Sign.Neg)){ 
					ui[1]*=2;
				}
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
			}
			break;	
		}
		case 5:{		  
			if(uind==2){
				if((Ps[0].equals(Sign.Zer)|| (Ps[0].equals(Sign.Neg))) && 
						(Ps[2].equals(Sign.Zer)|| (Ps[2].equals(Sign.Pos))))
				{ //System.out.println("This case is not instantiable : + + + * Q5 = "+Ps[0]+Ps[1]+Ps[2]);
					return null;}

				do{//solving the special case of + + -
					do {ui[0] = rn.nextInt(lim); ui[1] = rn.nextInt(lim); ui[2] = rn.nextInt(lim);}while(ui[0]==0 || ui[1]==0 || ui[2]==0);
				}while((ui[0]*Qi[0]+ui[1]*Qi[3]+ui[2]*Qi[6]<0)||(ui[0]*Qi[2]+ui[1]*Qi[5]+ui[2]*Qi[8]>0));

				if(Ps[1].equals(Sign.Pos) && Ps[2].equals(Sign.Neg) ){ 
					ui[2] =-(ui[0]*Qi[0]+ui[1]*Qi[3])/Qi[6];//solving the special case of P: 0 + - 	
					if(Ps[0].equals(Sign.Zer))break;//0+-
					else if(Ps[0].equals(Sign.Neg)){//-+-
						ui[2]*=2;
						break;
					}
				}
				if(Ps[0].equals(Sign.Pos) && Ps[1].equals(Sign.Pos) ){ 
					ui[0] =-(ui[1]*Qi[5]+ui[2]*Qi[8])/Qi[2];//solving special case of P: + + 0 		
					if(Ps[2].equals(Sign.Zer))break;//++0
					else if(Ps[2].equals(Sign.Pos)){//+++
						ui[0]*=2;
						break;
					}
				}

			}else if(uind==1){//Solving the special case of P=+ + 0
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
				ui[1] =-(ui[0]*Qi[2])/Qi[5];		
				ui[2] = 0;
				if(Ps[0].equals(Sign.Pos)){ 
					ui[0]*=2;
				}else if (Ps[0].equals(Sign.Neg)){ 
					ui[1]*=2;
				}
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
			}
			break;	
		}
		case 6:{		  
			if(uind==2){
				if((Ps[0].equals(Sign.Zer)|| (Ps[0].equals(Sign.Neg))) && 
						(Ps[1].equals(Sign.Zer)|| (Ps[1].equals(Sign.Pos))))
				{ //System.out.println("This case is not instantiable : + + + * Q6 = "+Ps[0]+Ps[1]+Ps[2]);
					return null;}

				do{//solving the special case of + - +
					do {ui[0] = rn.nextInt(lim); ui[1] = rn.nextInt(lim); ui[2] = rn.nextInt(lim);}while(ui[0]==0 || ui[1]==0 || ui[2]==0);
				}while((ui[0]*Qi[0]+ui[1]*Qi[3]+ui[2]*Qi[6]<0)||(ui[0]*Qi[1]+ui[1]*Qi[4]+ui[2]*Qi[7]>0));

				if(Ps[2].equals(Sign.Pos) && Ps[1].equals(Sign.Neg) ){ 
					ui[1] =-(ui[0]*Qi[0]+ui[2]*Qi[6])/Qi[3];//solving the special case of P: 0 - + 	
					if(Ps[0].equals(Sign.Zer))break;//0-+
					else if(Ps[0].equals(Sign.Neg)){//0-+
						ui[1]*=2;
						break;
					}
				}
				if(Ps[2].equals(Sign.Pos) && Ps[0].equals(Sign.Pos) ){ 
					ui[0] =-(ui[1]*Qi[4]+ui[2]*Qi[7])/Qi[1];//solving special case of P: + 0 + 		
					if(Ps[1].equals(Sign.Zer))break;//+0+
					else if(Ps[1].equals(Sign.Pos)){//+++
						ui[0]*=2;
						break;
					}
				}

			}else if(uind==1){//Solving the special case of P=+ + 0
				if(!Ps[0].equals(Ps[1])){ 
					//System.out.println("This case is not instantiable : + + 0 * Q6 = "+Ps[0]+Ps[1]+Ps[2]);
					return null;}
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
				ui[1] =-(ui[0]*Qi[0])/Qi[3];		
				ui[2] = 0;
				if(Ps[0].equals(Sign.Pos)){ 
					ui[0]*=2;
				}else if (Ps[0].equals(Sign.Neg)){ 
					ui[1]*=2;
				}
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
			}
			break;	
		}
		case 7:{		  
			if(uind==2){//Solving the special case of P=0 + 0
				do{
					do ui[0] = rn.nextInt(lim); while(ui[0]==0);
					ui[1] = -(ui[0]*Qi[2])/Qi[5];
					ui[2] = -(ui[0]*Qi[0]+ui[1]*Qi[3])/Qi[6];
					if(Ps[0].equals(Sign.Pos)){ 
						ui[2]*=.5;
					}else if (Ps[0].equals(Sign.Neg)){ 
						ui[2]*=2;
					}
					if(Ps[2].equals(Sign.Pos)){ 
						ui[0]+=of; ui[1]-=of*(Qi[0]/Qi[3]);
					}else if (Ps[2].equals(Sign.Neg)){ 
						ui[0]-=of; ui[1]+=of*(Qi[0]/Qi[3]);
					}
					itnum--;
				}while((ui[0]<=0 || ui[1] <= 0 || ui[2] <=0) && itnum>0);
			}else if(uind==1){//Solving the special case of P=+ + 0
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
				ui[1] =-(ui[0]*Qi[2])/Qi[5];		
				ui[2] = 0;
				if(Ps[1].equals(Sign.Pos)){ 
					ui[0]*=2;
				}else if (Ps[1].equals(Sign.Neg)){ 
					ui[1]*=2;
				}
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
			}
			break;	
		}
		case 8:{		  
			if(uind==2){//Solving the special case of P=0 0 +
				do{
					do ui[0] = rn.nextInt(lim); while(ui[0]==0);
					ui[2] = -(ui[0]*Qi[1])/Qi[7];
					ui[1] = -(ui[0]*Qi[0]+ui[2]*Qi[6])/Qi[3];
					if(Ps[0].equals(Sign.Pos)){ 
						ui[1]*=.5;
					}else if (Ps[0].equals(Sign.Neg)){ 
						ui[1]*=2;
					}
					if(Ps[1].equals(Sign.Pos)){ 
						ui[0]+=of; ui[2]-=of*(Qi[0]/Qi[6]);
					}else if (Ps[1].equals(Sign.Neg)){ 
						ui[0]-=of; ui[2]+=of*(Qi[0]/Qi[6]);
					}
					itnum--;
				}while((ui[0]<=0 || ui[1] <= 0 || ui[2] <=0) && itnum>0);
			}else if(uind==1){//Solving the special case of P=0 + +
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
				ui[1] =-(ui[0]*Qi[0])/Qi[3];		
				ui[2] = 0;
				if(Ps[1].equals(Sign.Pos)){ 
					ui[0]*=2;
				}else if (Ps[1].equals(Sign.Neg)){ 
					ui[1]*=2;
				}
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
			}
			break;	
		}
		case 9:{		  
			if(uind==2){//Solving the special case of P=0 + 0
				do{
					do ui[1] = rn.nextInt(lim); while(ui[1]==0);
					ui[2] = -(ui[1]*Qi[5])/Qi[8];
					ui[0] = -(ui[1]*Qi[3]+ui[2]*Qi[6])/Qi[0];
					if(Ps[0].equals(Sign.Pos)){ 
						ui[0]*=2;
					}else if (Ps[0].equals(Sign.Neg)){ 
						ui[0]*=.5;
					}
					if(Ps[2].equals(Sign.Pos)){ 
						ui[1]-=of; ui[2]+=of*(Qi[3]/Qi[6]);
					}else if (Ps[2].equals(Sign.Neg)){ 
						ui[1]+=of; ui[2]-=of*(Qi[3]/Qi[6]);
					}
					itnum--;
				}while((ui[0]<=0 || ui[1] <= 0 || ui[2] <=0) && itnum>0);
			}else if(uind==1){//Solving the special case of P=0 + -
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
				ui[1] =-(ui[0]*Qi[0])/Qi[3];		
				ui[2] = 0;
				if(Ps[1].equals(Sign.Pos)){ 
					ui[0]*=2;
				}else if (Ps[1].equals(Sign.Neg)){ 
					ui[1]*=2;
				}
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
			}
			break;	
		}
		case 10:{		  
			if(uind==2){//Solving the special case of P=+ + 0
				do{ ui[0] = rn.nextInt(lim); ui[1] = rn.nextInt(lim); }while(ui[0]==0 || ui[1]==0);
				ui[2] =-(ui[1]*Qi[5])/Qi[8];		
				if(Ps[2].equals(Sign.Pos)){ 
					ui[2]*=2;
				}else if (Ps[2].equals(Sign.Neg)){ 
					ui[1]*=2;
				}
			}else if(uind==1){//Solving the special case of P=+ + -
				do{ ui[0] = rn.nextInt(lim); ui[1] = rn.nextInt(lim); }while(ui[0]==0 || ui[1]==0);
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
			}
			break;	
		}
		case 11:{		  
			if(uind==2){//Solving the special case of P=+ + 0
				do{ ui[0] = rn.nextInt(lim); ui[1] = rn.nextInt(lim); }while(ui[0]==0 || ui[1]==0);
				ui[2] =-(ui[0]*Qi[2])/Qi[8];		
				if(Ps[2].equals(Sign.Pos)){ 
					ui[2]*=2;
				}else if (Ps[2].equals(Sign.Neg)){ 
					ui[0]*=2;
				}
			}else if(uind==1){//Solving the special case of P=+ + -
				do{ ui[0] = rn.nextInt(lim); ui[1] = rn.nextInt(lim); }while(ui[0]==0 || ui[1]==0);
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
			}
			break;	
		}
		case 12:{		  
			if(uind==2){//Solving the special case of P=+ 0 +
				do{ ui[0] = rn.nextInt(lim); ui[2] = rn.nextInt(lim); }while(ui[0]==0 || ui[2]==0);
				ui[1] =-(ui[0]*Qi[1])/Qi[4];		
				if(Ps[1].equals(Sign.Pos)){ 
					ui[1]*=2;
				}else if (Ps[1].equals(Sign.Neg)){ 
					ui[0]*=2;
				}
			}else if(uind==1){//Solving the special case of P=+ 0 0
				do{ ui[0] = rn.nextInt(lim); }while(ui[0]==0);
				ui[1] =-(ui[0]*Qi[1])/Qi[4];		
				if(Ps[1].equals(Sign.Pos)){ 
					ui[1]*=2;
				}else if (Ps[1].equals(Sign.Neg)){ 
					ui[0]*=2;
				}
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
			}
			break;	
		}
		case 13:{		  
			if(uind==2){
				do{ ui[0] = rn.nextInt(lim); ui[1] = rn.nextInt(lim); ui[2] = rn.nextInt(lim); }while(ui[0]==0 || ui[1]==0 || ui[2]==0);
			}else if(uind==1){
				do{ ui[0] = rn.nextInt(lim); ui[1] = rn.nextInt(lim); }while(ui[0]==0 || ui[1]==0);
			}else if(uind==0){
				do ui[0] = rn.nextInt(lim); while(ui[0]==0);
			}
			break;	
		}
		}
		return ui;
	}

	public static void uxQinstatiation(){
		String[][][] uQ = new String[14][3][9];//14 for Q,3 for u, 9 for maximum number of u.Q in all possible cases
		try{
			BufferedReader in = new BufferedReader(new FileReader("uxQsignMatrices.txt")); 
			for(int i=0; i<14; i++){
				String s = in.readLine();						
				uQ[i][2] = new String[(s.length()/3)];
				for(int w = 0; w < (s.length()/3); w++)
					uQ[i][2][w] = s.substring(3*w, 3*(w+1));	
				s = in.readLine();						
				uQ[i][1] = new String[(s.length()/3)];
				for(int w = 0; w < (s.length()/3); w++)
					uQ[i][1][w] = s.substring(3*w, 3*(w+1));	
				uQ[i][0] = new String[1];
				uQ[i][0][0] = in.readLine();				
			}

			FileWriter fstream = new FileWriter("uxQintances.txt");
			BufferedWriter out = new BufferedWriter(fstream);
			double[] Qi=null;
			for(int qq=0; qq<Q.length; qq++){
				Qi = QrandomInstan(qq); 
				//out.write(Q[qq]);
				for (int uu = 0; uu < u.length; uu++) {
					out.write(u[uu]+Q[qq]+" ");
					for (int i = 0; i < uQ[qq][uu].length; i++) {
						int coun=1000;
						while(Qi.equals(null) && coun > 0){
							Qi = QrandomInstan(qq); 
							coun--;
						}
						out.write(uQ[qq][uu][i]+" ");
						out.write(stringPrint(normalize(uxQRandomIns(uu, qq, Qi, QstrToQsign(uQ[qq][uu][i])))));
						out.write(stringPrint(Qi));
					}
					out.newLine();
				}
			}
			in.close();
			out.close();
		}catch(Exception e){
			System.out.println("Exception : " + e);
		}
	}	

	public static Sign[] QsxQs(Sign[] Q1s, Sign[] Q2s){
		Sign[] QsxQs = new Sign[9];
		Sign[] TQsign= transpose(Q2s);//Transpose of Q[j], just for making the cross product of usign and Qsign easier	
		for(int j=0; j<3; j++){//row
			for(int k=0; k<3; k++){//column
				QsxQs[j*3+k] = Sign.sum3(Sign.dot2(Q1s[j*3+0],TQsign[k*3+0]), Sign.dot2(Q1s[j*3+1],TQsign[k*3+1]), Sign.dot2(Q1s[j*3+2],TQsign[k*3+2]));
			}
		}
		return QsxQs;
	}

	public static boolean patternMatching(Sign[] pattern, Sign[] subject){
		int i=0;
		while(i<pattern.length){
			if(!pattern[i].equals(Sign.Ind) && !pattern[i].equals(subject[i]))
				return false;
			i++;
		}
		return true;
	}

	public static boolean patternMatching(Sign[] pattern, int[] subject){
		int i=0;
		while(i<pattern.length){
			if(!pattern[i].equals(Sign.Ind) && !pattern[i].equals(subject[i]))
				return false;
			i++;
		}
		return true;
	}

	public static boolean patternMatching(Sign[] pattern, double[] subject){
		int i=0;
		while(i<pattern.length){
			if(!pattern[i].equals(Sign.Ind) && !pattern[i].equals(subject[i]))
				return false;
			i++;
		}
		return true;
	}

	public static Sign[] row(Sign[] Matrix, int row){
		Sign[] rw = new Sign[3];
		rw[0] = Matrix[3*row+0]; rw[1] = Matrix[3*row+1]; rw[2] = Matrix[3*row+2];
		return rw;
	}

	public static void QsxQscalculator(){
		String[][][] uQ = new String[14][3][9];
		HashSet<String> QxQintersectionSet;
		HashSet<String> QxQtransposeSet;
		try{
			BufferedReader in = new BufferedReader(new FileReader("uxQsignMatrices.txt")); 
			
			for(int i=0; i<14; i++){
				String s = in.readLine();						
				uQ[i][2] = new String[(s.length()/3)];
				for(int w = 0; w < (s.length()/3); w++)	   uQ[i][2][w] = s.substring(3*w, 3*(w+1));	
				s = in.readLine();						
				uQ[i][1] = new String[(s.length()/3)];
				for(int w = 0; w < (s.length()/3); w++)	   uQ[i][1][w] = s.substring(3*w, 3*(w+1));	
				uQ[i][0] = new String[1];
				uQ[i][0][0] = in.readLine();				
			}
		}catch(Exception e){
			System.out.println("Exception : " + e);
		}
		try{
			//BufferedWriter out = new BufferedWriter(new FileWriter("QxQinstances.txt", true));
			//BufferedWriter out2 = new BufferedWriter(new FileWriter("QxQpotentialcases.txt", true));
		//	BufferedWriter out3 = new BufferedWriter(new FileWriter("QxQtotcases.txt"));
			for(int i=0; i<14; i++){
				Sign[] Q1 = QstrToQsign(Q[i]);
				String Q1row[] = new String[3];
				for(int j=0; j<14; j++){
					Sign[] Q2 = QstrToQsign(Q[j]);
					Sign[] Q1xQ2 = QsxQs(Q1,Q2);
					QxQintersectionSet = new HashSet<String>();
					HashSet<String> rows[] = (HashSet<String>[])new HashSet[3];
					int[] Uidx= new int[3];// fPLidx = new int[3];
					int[][] PLidx= new int[3][4];
					int[][] Qidx= new int[3][4];
					int[][] PRidx= new int[3][4];
					double[][] QjInsxP = new double[3][9];
					int[] fIxL = new int[3];
					for(int r=0; r<3; r++){// iterates over the rows of Q1
						Q1row[r] = ""+Q1[3*r+0]+Q1[3*r+1]+Q1[3*r+2];
						factorToUP(Q1row[r]);//uu = u[uInx]*P[vpInx]
						Uidx[r] = uInx;
						switch(uInx){
						case 0:{ fIxL[r] = 2; break;}
						case 1:{ fIxL[r] = 4;break;}
						case 2:{ fIxL[r] = 3;break;}
						}

						int row=0;
						rows[r] = new HashSet<String>();
						do{
							PLidx[r][row] = vpInx[row];
							factorToQP(PQ[j][PLidx[r][row]]);
							Qidx[r][row] = qInx;  	PRidx[r][row] = pInx;
							for(int w=0; w < uQ[Qidx[r][row]][Uidx[r]].length; w++)
								rows[r].add(QxP(uQ[Qidx[r][row]][Uidx[r]][w], P[PRidx[r][row]]));
							row++;
						}while((uInx==2 && row<3) || (uInx==1 && row<4) || (uInx==0 && row<2));
					}

					QxQtransposeSet = new HashSet<String>();
					String Q2T = transpose(Q[j]);
					String Q1T = transpose(Q[i]);
					int[] transindices = RxSfactor(Q2T, Q1T);
					String transposeKey = Q[transindices[0]]+Q[transindices[1]];
					BufferedReader in = new BufferedReader(new FileReader("QxQpotentialcases.txt")); 
					String s=in.readLine();
					while(s!=null){
						if(s.substring(0, 18).equals(transposeKey)){
							String[] tran = s.split(" ");
							String trasProd = QxP(tran[1], P[transindices[2]]);
							trasProd = transpose(trasProd);
							QxQtransposeSet.add(trasProd);
						}

						s = in.readLine();
					}
					in.close();
					
					Iterator<String> w0 = rows[0].iterator();
					while(w0.hasNext()){
						String row0 = w0.next();
						Iterator<String> w1 = rows[1].iterator();
						while(w1.hasNext()){
							String row1 = w1.next();
							Iterator<String> w2 = rows[2].iterator();
							while(w2.hasNext()){
								String row2 = w2.next();
								String mat = row0+row1+row2;
								if(patternMatching(Q1xQ2, QstrToQsign(mat)) && QxQtransposeSet.contains(mat))
									QxQintersectionSet.add(mat); 
							}	
						}						
					}

					double[] Q1i = new double[9];
					for(int q=0; q<14; q++){// This goes through 14 Representative matrices
						String Q3P="";
						for(int p=0; p<24; p++){//This goes through 24 Permutation matrices

							Q3P = QxP(Q[q],P[p]);	
							Sign[] Q3 = QstrToQsign(Q3P);
							if(QxQintersectionSet.contains(Q3P) && !BQQQP[i][j][q][p]){//Q3P.equals(Q1xQ2Array[qq])
								if(!BQQtot[i][j]){
									//out3.write(Q[i]+Q[j]+" "+Q3P);
									//out3.newLine();
									QxQtotNum[i][j]++;}
								int nu=100, ny=0;
								double[] Q1ui0 = new double[]{0,0,0};
								double[] Q1ui1 = new double[]{0,0,0};
								double[] Prod;
								int T = 100;
								outLoop:
									while(ny < 6 ){
										ny++;
										//System.out.println("ny: "+ny);
										double[] QjIns=QrandomInstan(j);
										int[] fIx = new int[3];
										switch(ny){
										case 1:{//instanciate row 0 and 1 respectivly
											do{ 
												if( i<10 && (Q1[6].equals(Sign.Zer) || Q1[7].equals(Sign.Zer) || Q1[8].equals(Sign.Zer)))
													break;
												nu=T;
												innerLoop:
													do{
														QjIns = QrandomInstan(j);
														nu--;	
														QjInsxP[0] = QxP(PxQ(P[PLidx[0][fIx[0]]], QjIns),transpose(P[PRidx[0][fIx[0]]]));
														Sign[] pi0 = QstrToQsign(QxP(Q3P.substring(0, 3), transpose(P[PRidx[0][fIx[0]]])));
														Q1ui0 = uxQRandomIns(Uidx[0], Qidx[0][fIx[0]], QjInsxP[0], pi0);
														if(Q1ui0==null){continue innerLoop;}
														Q1ui0 = QxP(Q1ui0, P[PLidx[0][fIx[0]]]);
														Sign[] Q1row1 = row(Q1,1);//second row in Q1
														Sign[] Q3row1 = row(Q3,1);//second row in Q3
														Q1ui1 = secondRowQ1(Q1row1, QjIns, Q3row1, Q1ui0);
														if(Q1ui1!=null){ break;}
													}while(nu > 0);
												fIx[0]++;
											}while(fIx[0]<fIxL[0]);
											break;
										}
										case 2:{//instanciate row 0 and 2 respectivly : P[7]*Q1
											do{ 
												if(i<10 && (Q1[3].equals(Sign.Zer) || Q1[4].equals(Sign.Zer) || Q1[5].equals(Sign.Zer)))
													break ;
												nu=T;
												innerLoop:
													do{
														QjIns = QrandomInstan(j);
														nu--;	
														QjInsxP[0] = QxP(PxQ(P[PLidx[0][fIx[0]]], QjIns),transpose(P[PRidx[0][fIx[0]]]));
														Sign[] pi0 = QstrToQsign(QxP(Q3P.substring(0, 3), transpose(P[PRidx[0][fIx[0]]])));
														Q1ui0 = uxQRandomIns(Uidx[0], Qidx[0][fIx[0]], QjInsxP[0], pi0);
														if(Q1ui0==null){continue innerLoop;}
														Q1ui0 = QxP(Q1ui0, P[PLidx[0][fIx[0]]]);
														Sign[] Q1row2 = row(Q1,2);
														Sign[] Q3row2 = row(Q3,2);
														Q1ui1 = secondRowQ1(Q1row2, QjIns, Q3row2, Q1ui0);
														if(Q1ui1!=null){ break;}
													}while(nu > 0);
												fIx[0]++;
											}while(fIx[0]<fIxL[0]);
											break;
										}
										case 3:{//instanciate row 1 and 0 respectivly : P[13]*Q1
											do{ 
												if(i<10 && (Q1[6].equals(Sign.Zer) || Q1[7].equals(Sign.Zer) || Q1[8].equals(Sign.Zer)))
													break ;
												nu=T;
												innerLoop:
													do{
														QjIns = QrandomInstan(j);
														nu--;	
														QjInsxP[1] = QxP(PxQ(P[PLidx[1][fIx[1]]], QjIns),transpose(P[PRidx[1][fIx[1]]]));
														Sign[] pi1 = QstrToQsign(QxP(Q3P.substring(3, 6), transpose(P[PRidx[1][fIx[1]]])));
														Q1ui0 = uxQRandomIns(Uidx[1], Qidx[1][fIx[1]], QjInsxP[1], pi1);
														if(Q1ui0==null){continue innerLoop;}
														Q1ui0 = QxP(Q1ui0, P[PLidx[1][fIx[1]]]);
														Sign[] Q1row0 = row(Q1,0);
														Sign[] Q3row0 = row(Q3,0);
														//System.out.println("Before entring the secondRowQ1");
														Q1ui1 = secondRowQ1(Q1row0, QjIns, Q3row0, Q1ui0);
														//System.out.println("Afer entring the secondRowQ1");
														if(Q1ui1!=null){ break;}
													}while(nu > 0);
												fIx[1]++;
											}while(fIx[1]<fIxL[1]);
											break;
										}
										case 4:{//instanciate row 1 and 2 respectivly: P[15]*Q1
											do{ 
												if(i<10 && (Q1[0].equals(Sign.Zer) || Q1[1].equals(Sign.Zer) || Q1[2].equals(Sign.Zer)))
													break ;
												nu=T;
												innerLoop:
													do{
														QjIns = QrandomInstan(j);
														nu--;	
														QjInsxP[1] = QxP(PxQ(P[PLidx[1][fIx[1]]], QjIns),transpose(P[PRidx[1][fIx[1]]]));
														Sign[] pi1 = QstrToQsign(QxP(Q3P.substring(3, 6), transpose(P[PRidx[1][fIx[1]]])));
														Q1ui0 = uxQRandomIns(Uidx[1], Qidx[1][fIx[1]], QjInsxP[1], pi1);
														if(Q1ui0==null){continue innerLoop;}
														Q1ui0 = QxP(Q1ui0, P[PLidx[1][fIx[1]]]);
														Sign[] Q1row2 = row(Q1,2);
														Sign[] Q3row2 = row(Q3,2);
														Q1ui1 = secondRowQ1(Q1row2, QjIns, Q3row2, Q1ui0);
														if(Q1ui1!=null){ break;}
													}while(nu > 0);
												fIx[1]++;
											}while(fIx[1]<fIxL[1]);
											break;
										}
										case 5:{//instanciate row 2 and 0 respectivly : P[21]*Q1
											do{ 
												if(i<10 && (Q1[3].equals(Sign.Zer) || Q1[4].equals(Sign.Zer) || Q1[5].equals(Sign.Zer)))
													break ;
												nu=T;
												innerLoop:
													do{
														QjIns = QrandomInstan(j);
														nu--;
														QjInsxP[2] = QxP(PxQ(P[PLidx[2][fIx[2]]], QjIns),transpose(P[PRidx[2][fIx[2]]]));
														Sign[] pi2 = QstrToQsign(QxP(Q3P.substring(6, 9), transpose(P[PRidx[2][fIx[2]]])));
														Q1ui0 = uxQRandomIns(Uidx[2], Qidx[2][fIx[2]], QjInsxP[2], pi2);
														if(Q1ui0==null){continue innerLoop;}
														Q1ui0 = QxP(Q1ui0, P[PLidx[2][fIx[2]]]);
														Sign[] Q1row0 = row(Q1,0);
														Sign[] Q3row0 = row(Q3,0);
														Q1ui1 = secondRowQ1(Q1row0, QjIns, Q3row0, Q1ui0);
														if(Q1ui1!=null){ break;}
													}while(nu > 0);
												fIx[2]++;
											}while(fIx[2]<fIxL[2]);
											break;
										}
										case 6:{//instanciate row 2 and 1 respectivly: P[23]*Q1
											do{ 
												if(i<10 && (Q1[0].equals(Sign.Zer) || Q1[1].equals(Sign.Zer) || Q1[2].equals(Sign.Zer)))
													break ;
												nu=T;
												innerLoop:
													do{
														QjIns = QrandomInstan(j);
														nu--;
														QjInsxP[2] = QxP(PxQ(P[PLidx[2][fIx[2]]], QjIns),transpose(P[PRidx[2][fIx[2]]]));
														Sign[] pi2 = QstrToQsign(QxP(Q3P.substring(6, 9), transpose(P[PRidx[2][fIx[2]]])));
														Q1ui0 = uxQRandomIns(Uidx[2], Qidx[2][fIx[2]], QjInsxP[2], pi2);
														if(Q1ui0==null){continue innerLoop;}
														Q1ui0 = QxP(Q1ui0, P[PLidx[2][fIx[2]]]);
														Sign[] Q1row1 = row(Q1,1);
														Sign[] Q3row1 = row(Q3,1);
														Q1ui1 = secondRowQ1(Q1row1, QjIns, Q3row1, Q1ui0);
														if(Q1ui1!=null){ break;}

													}while(nu > 0);
												fIx[2]++;
											}while(fIx[2]<fIxL[2]);
											break;
										}
										}							
										if(Q1ui0==null || Q1ui1==null) continue outLoop;								
										normalize(Q1ui0);
										normalize(Q1ui1);
										double[] Q1ui2 = new double[3];
										Q1ui2[0] = Q1ui0[1]*Q1ui1[2]-Q1ui0[2]*Q1ui1[1];
										Q1ui2[1] = Q1ui0[2]*Q1ui1[0]-Q1ui0[0]*Q1ui1[2];
										Q1ui2[2] = Q1ui0[0]*Q1ui1[1]-Q1ui0[1]*Q1ui1[0];
										Q1i[0] = Q1ui0[0]; Q1i[1] = Q1ui0[1]; Q1i[2] = Q1ui0[2];
										Q1i[3] = Q1ui1[0]; Q1i[4] = Q1ui1[1]; Q1i[5] = Q1ui1[2];
										Q1i[6] = Q1ui2[0]; Q1i[7] = Q1ui2[1]; Q1i[8] = Q1ui2[2];
										switch(ny){
										case 2:{
											Q1i[6] = -Q1i[6]; Q1i[7] = -Q1i[7]; Q1i[8] = -Q1i[8];
											Q1i = PxQ(P[6],Q1i);//T(P[6])= P[7]
											break;
										}
										case 3:{
											Q1i[6] = -Q1i[6]; Q1i[7] = -Q1i[7]; Q1i[8] = -Q1i[8];
											Q1i = PxQ(P[13],Q1i);//T(P[13])= P[13]
											break;
										}
										case 4:{
											Q1i = PxQ(P[21],Q1i);//T(P[15])= P[21]
											break;
										}
										case 5:{
											Q1i = PxQ(P[15],Q1i);//T(P[21])= P[15]
											break;
										}
										case 6:{
											Q1i[6] = -Q1i[6]; Q1i[7] = -Q1i[7]; Q1i[8] = -Q1i[8];
											Q1i = PxQ(P[19],Q1i);//T(P[23])= P[19]
											break;
										}
										}
										if(!patternMatching(Q1, Q1i)) continue outLoop;
										Prod = MlxMr(Q1i, QjIns);
										if(patternMatching(Q3, Prod)){
											BQQQP[i][j][q][p]= true;
//											out.write(Q[i]+Q[j]+" "+Q3P+" ");
//											out.write(stringPrint(Q1i));
//											out.write(stringPrint(QjIns));
//											out.newLine();
											break outLoop;
										}
									}						
							}
						}
					}
				}
			}
			for (int i = 0; i < 14; i++) {
				for (int j = 0; j < 14; j++) {
					BQQtot[i][j]=true;
				}
			}
		//out.close();
		//out2.close();
	    //out3.close();
		}catch(Exception e){
			System.out.println("Exception : ");e.printStackTrace();
		}
	}

	public static void signMatrixReader(){
		try{
			BufferedReader in = new BufferedReader(new FileReader("SignMatrices.txt"));
			//			  FileWriter fstream = new FileWriter("signRotations.txt");
			//			  BufferedWriter out = new BufferedWriter(fstream);
			int siz=0;
			String s = in.readLine();
			while(s!=null){
				Sign[] mat = new Sign[9];
				char[] signs= new char[9];
				s.getChars(0, 9, signs, 0);
				for(int q=0; q < 9; q++){
					mat[q]= new Sign(signs[q]);
				}
				signMatList.add(mat.clone());

				siz++;
				//				  out.write(""+siz+":");
				//				  out.newLine();
				//				  out.write(squarPrint(s));
				//				  out.newLine();
				s = in.readLine();
			}
			//  out.close();
		}catch(Exception e){
			System.out.println("Exception : " + e);
		}
	}

	public static void main(String[] args) {
		
		//String Vec="";
		int Rot=0, RL=0, RR=0;
		signMatrixReader();
		permutationGenerator();
		//***********************************************************************************************************
//		QxQinstantiatTranspose();
//      uxQinstatiation(); //THIS FILLS THE U.Q INSTANCES FILE
//		for (int i = 0; i < 1; i++) {//THIS PART FILLS THE Q.Q INSTANCES FILE
//			QsxQscalculator();			
//		}
//		try{
//			BufferedReader in = new BufferedReader(new FileReader("QxQinstances.txt")); 
//			String s=in.readLine();
//			while(s!=null){
//				for (int i = 0; i < 14; i++) {
//					for (int j = 0; j < 14; j++) {
//						String k=Q[i]+Q[j];
//						if(s.substring(0, 18).equals(k)) QxQachivedNum[i][j]++;
//					}
//				}
//				s = in.readLine();
//			}
//			in.close();
//		}catch(Exception e){
//			System.err.println(e.getCause());e.printStackTrace();
//		}
//		for (int i = 0; i < 14; i++) {
//			for (int j = 0; j < 14; j++) {
//				System.out.print(QxQachivedNum[i][j]+"/"+QxQtotNum[i][j]+"  ");
//			}
//			System.out.println();
//		}
		//***********************************************************************************************************
		String fr,sr,tr, fs, ss,ts;
		try {
			System.out.println("Enter the number of operation:" +'\n'+"1: Vector rotation." +'\n'+"2: Rotation composition.");
			BufferedReader buf = new BufferedReader(new InputStreamReader(System.in));
			int i = Integer.parseInt(buf.readLine());
			if(i!=1 && i!=2) {
				System.err.println("The entered number is not valid");
				System.exit(0);
			}

			switch(i){
			case 1:{
				System.out.println("Sample :-+0 \nEnter the triple sign vector as the sample (No space between the signs):");
				buf = new BufferedReader(new InputStreamReader(System.in));
				Vec = buf.readLine();
				Vec = setVec(Vec);
				System.out.println("Enter the first row vector for the rotation:");
				buf = new BufferedReader(new InputStreamReader(System.in));
				fr = setVec(buf.readLine());
				System.out.println("Enter the second row vector for the rotation:");
				buf = new BufferedReader(new InputStreamReader(System.in));
				sr = setVec(buf.readLine());
				ArrayList<String> trs = getThirdRow(fr,sr);
				if(trs.size()==0){
					System.out.println("There is no sign rotations with the indicated first and second rows");
					System.exit(0);
				}else System.out.println("The existing sign rotations with the above first and second rows:");
				for(String thr: trs) System.out.println(squarPrint(thr));
				System.out.println("Enter the third row vector for the rotation:");
				buf = new BufferedReader(new InputStreamReader(System.in));
				tr = setVec(buf.readLine());
				RRM = fr+sr+tr;			
				Rot = getRot(RRM);
				RRM = stringPrint(signMatList.get(Rot));
				System.out.println("You entered: \n"+squarPrintvxM(Vec,RRM));				
				vxR(Vec, RRM);
				break;
			}
			case 2:{
				System.out.println("Sample :-+0");
				//				System.out.println("Enter the left rotation id# (Enter a number between 1 and 336.\nThe file of rotations is availabel under the name signRotations.txt):");
				//				buf = new BufferedReader(new InputStreamReader(System.in));
				//				RL = Integer.parseInt(buf.readLine());
				//				if(!(RL>=1 && RL <=336))throw new Exception();

				System.out.println("Enter the first row vector for the left rotation as the sample:");
				buf = new BufferedReader(new InputStreamReader(System.in));
				fs = buf.readLine();
				fs = setVec(fs);
				System.out.println("Enter the second row vector for the left rotation:");
				buf = new BufferedReader(new InputStreamReader(System.in));
				ss = setVec(buf.readLine());
				ArrayList<String> tss = getThirdRow(fs,ss);
				if(tss.size()==0){
					System.out.println("There is no sign rotations with the indicated first and second rows");
					System.exit(0);
				}else System.out.println("The existing sign rotations with the above first and second rows:");
				for(String thr: tss) System.out.println(squarPrint(thr));
				System.out.println("Enter the third row vector for the left rotation:");
				buf = new BufferedReader(new InputStreamReader(System.in));
				ts = setVec(buf.readLine());
				RLM = fs+ss+ts;			
				Rot = getRot(RLM);
				RLM = stringPrint(signMatList.get(Rot));
				////////////////////////////////////////////////////////////////////////			
				System.out.println("Enter the first row vector for the right rotation:");
				buf = new BufferedReader(new InputStreamReader(System.in));
				fr = setVec(buf.readLine());
				System.out.println("Enter the second row vector for the right rotation:");
				buf = new BufferedReader(new InputStreamReader(System.in));
				sr = setVec(buf.readLine());
				ArrayList<String> trs = getThirdRow(fr,sr);
				if(trs.size()==0){
					System.out.println("There is no sign rotations with the indicated first and second rows");
					System.exit(0);
				}else System.out.println("The existing sign rotations with the above first and second rows:");
				for(String thr: trs) System.out.println(squarPrint(thr));
				System.out.println("Enter the third row vector for the right rotation:");
				buf = new BufferedReader(new InputStreamReader(System.in));
				tr = setVec(buf.readLine());
				RRM = fr+sr+tr;			
				Rot = getRot(RRM);
				RRM = stringPrint(signMatList.get(Rot));



				System.out.println("You entered: \n"+squarPrintMxM(RLM,RRM));
				RxS(RLM,RRM);												
				break;
			}
			}
		} catch(NumberFormatException e){
			System.err.println("Not a valid number");
			System.exit(0);
		}
		catch (Exception ex) {
			ex.printStackTrace();
		}
	}
	//	static String printWithBracket(String matrix){
	//		String out = "";
	//		for (int i = 0; i < matrix.length(); i+=3) {
	//			out+="|"+matrix.charAt(i)+matrix.charAt(i)+matrix.charAt(i)+"|\n";
	//		}
	//		return out;
	//	}
	static String setVec(String ve){
		if(!((ve.charAt(0)=='-'||ve.charAt(0)=='0'||ve.charAt(0)=='+') &&
				(ve.charAt(1)=='-'||ve.charAt(1)=='0'||ve.charAt(1)=='+')&&
				(ve.charAt(2)=='-'||ve.charAt(2)=='0'||ve.charAt(2)=='+'))){
			System.err.println("Not a valid sign vector");
			System.exit(0);
		}
		return ve;
	}
	static ArrayList<String> getThirdRow(String frow, String srow){
		ArrayList<String> machings = new ArrayList<String>();
		String twoRows = frow+srow;
		String ro,ro6;
		for(Sign[] rot: signMatList){
			ro = stringPrint(rot);
			ro6 = ro.substring(0, 6);
			if(twoRows.equals(ro6)) machings.add(ro);
		}
		return machings;
	}
	static int getRot(String r){
		boolean found = false;
		String srot;
		int i=0;
		for(Sign[] rot: signMatList){
			srot = stringPrint(rot);
			if(r.equals(srot)) {
				found = true;
				break;
			}
			i++;
		}	
		if(found) return i;
		else{
			System.err.println("Not a valid sign rotation");
			System.exit(0);
			return -1;
		}
	}
}
